<?php

namespace App\Http\Controllers;

use App\Http\Requests\ClientProfileUpdateRequest;
use App\Http\Requests\ClientStoreRequest;
use App\Models\ClientInfo;
use App\Models\ServicePackage;
use App\Models\User;
use App\Services\UserService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class ClientInfoController extends Controller
{
    /**
     * Display a listing of the resource.
     */


    public function clientList()
    {
        $clients = User::with('package')->where('user_type_id', 1)->get();


        return view('app.users.client-list', compact('clients'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function getUserProfile()
    {
        $user = User::with(['currentSSP', 'country_code'])->where('id', auth()->id())->first();
        $package = ServicePackage::where('id', $user->currentSSP->spac_id ?? 1)->first();
        return view('app.users.profile', compact('user', 'package'));
    }

    public function clientProfileModal($client_id)
    {
        $userService = new UserService();
        $user = $userService->getUserProfile($client_id);
        $user->with('country_code');


        $html = view('app.components.client-profile', compact('user'))->render();

        return response()->json(['html' => $html], 200);
    }

    /**
     * Store a newly created resource in storage.
     */


    /**
     * Display the specified resource.
     */
    public function updateProfile(ClientProfileUpdateRequest $request)
    {

        $user = User::where('id', $request->id)->first();
        $user->full_name = $request->full_name;
        $user->password = Hash::make($request->password);

        return back()->with('success', 'Profile Updated');
    }

    public function updateScanPermission(Request $request)
    {
        $user = User::where('id', auth()->id())->first();
        $user->scan_permission = $request->permission;
        $user->save();

        return response()->json(['message' => 'Permission updated successfully'], 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ClientInfo $clientInfo)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, ClientInfo $clientInfo)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ClientInfo $clientInfo)
    {
        //
    }
}
