<?php

namespace App\Http\Controllers;

use App\Services\DashboardService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class DashboardController extends Controller
{
    public function dashboard(DashboardService $dashboardService)
    {
        $card_html = Auth::user()->user_type_id != 1 ? $dashboardService->getAdminDashboardCard() : $dashboardService->getUserDashboardCard();
        return view('app.layouts.dashboard', compact('card_html'));
     }

    public function wizard(){
        return view('app.components.wizard');
    }

}
