<?php

namespace App\Http\Controllers;

use App\Http\Requests\ServicePackageStoreReq;
use App\Http\Requests\ServicePackageUpdateReq;
use App\Models\ServiceCategory;
use App\Models\ServicePackage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

use function Termwind\render;

class ServicePackageController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('app.service-packages.index', [
            'servicePackages' => ServicePackage::with('serviceCategory')->orderBy('id', 'desc')->get()
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $serviceCategories = ServiceCategory::all();
        $title = 'Create Service Package';
        $action = 'create';
        $servicePackage = false;
        $html = View::make('app.service-packages.modal', compact('serviceCategories', 'title', 'action', 'servicePackage'))->render();

        return response()->json(['html' => $html]);

    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ServicePackageStoreReq $request)
    {

        $sp = ServicePackage::create($request->only('scat_id', 'package_name', 'qty', 'price', 'discount', 'type', 'features'));
        return successResponse('Service Package created successfully', 201, $sp);

    }

    /**
     * Display the specified resource.
     */
    public function show(ServicePackage $servicePackage)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ServicePackage $servicePackage)
    {
        $serviceCategories = ServiceCategory::all();
        $title = 'Update Service Package';
        $action = 'update';
        $html = View::make('app.service-packages.modal', compact('serviceCategories', 'servicePackage', 'title', 'action'))->render();

        return response()->json(['html' => $html]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(ServicePackageUpdateReq $request, ServicePackage $servicePackage)
    {
        $servicePackage->update($request->only('scat_id', 'package_name', 'qty', 'price', 'discount', 'type', 'features'));

        return successResponse('Service Package updated successfully', 200, $servicePackage);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ServicePackage $servicePackage)
    {
        $servicePackage->delete();

        return successResponse('Service Package deleted successfully', 200, $servicePackage);
    }
}
