<?php

namespace App\Http\Controllers\website;

use App\Http\Controllers\Controller;
use App\Models\ServicePackage;
use Illuminate\Http\Request;
use PackageService;

class IndexController extends Controller
{


    public function index()
    {
        return view('web.index2');
    }



    public function getMonthlyPackage()
    {
        $package = ServicePackage::with('serviceCategory')->where('type', 'monthly')->get();
        $html = view('web.monthly-package', compact('package'))->render();
        return response()->json(['html' => $html]);
    }

    public function getYearlyPackage()
    {
        $package = ServicePackage::with('serviceCategory')->where('type', 'yearly')->get();
        $html = view('web.yearly-package', compact('package'))->render();
        return response()->json(['html' => $html]);
    }
}
