<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AddreesStore extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|string',
            'contact_email' => 'required|email',
            'country_code_id' => 'required_with:contact_phone',
            'contact_phone' => 'required_with:country_code_id',
            'address' => 'required|string',
            'note' => 'nullable|string',
            'city' => 'required|string',
            'province' => 'required|string',
            'country_id' => 'required|string',
            'postal_code' => 'required|string',
            'lat' => 'nullable|numeric',
            'long' => 'nullable|numeric',
        ];
    }

}
