<?php

namespace App\Http\Requests;

use App\Exceptions\ValidationExp;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;

class ServicePackageUpdateReq extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'scat_id' => ['required', 'integer', 'exists:service_categories,id'],
            'package_name' => ['required', 'string', 'max:255', 'unique:service_packages,package_name,'. $this->route('service_package')->id],
            'qty' => ['required', 'numeric'],
            'price' => ['required', 'numeric'],
            'discount' => ['required', 'numeric'],
            'type' => ['required', 'string', 'in:monthly,yearly']
        ];
    }


    protected function failedValidation(Validator $validator)
    {
        throw new ValidationExp($validator->errors());
    }

}
