<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AddressBook extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];

    public function country()
    {
        return $this->belongsTo(CountryCode::class, 'country_id', 'id');
    }

    public function countryCode()
    {
        return $this->belongsTo(CountryCode::class, 'country_code_id', 'id');
    }

    public function client()
    {
        return $this->belongsTo(User::class, 'client_id', 'id');
    }


}
