<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Contracts\Auth\MustVerifyEmail;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, SoftDeletes, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $guarded = [];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];


    public function package()
    {
        return $this->hasOne(ServicePackage::class, 'id', 'spac_id')->with('serviceCategory');
    }

    public function role()
    {
        return $this->hasOne(Role::class, 'id', 'user_type_id');
    }

    public function country_code()
    {
        return $this->hasOne(CountryCode::class, 'id', 'country_code_id');
    }

    public function clients()
    {
        return $this->where('user_type_id', 1);
    }

    public function pendingInvoice()
    {
        return $this->hasMany(SubscriptionServicePackage::class, 'client_id', 'id')->whereNull('payment_date')->count();
    }

    public function currentSSP()
    {
        return $this->hasOne(SubscriptionServicePackage::class, 'client_id', 'id')->where('status', 'current');
    }
}
