<?php

namespace App\Services;

use App\Models\AddressBook;
use Illuminate\Http\Request;

class AddressBookService
{
    function store(Request $request, $client_id)
    {
        return AddressBook::create([
            'client_id' => $client_id,
            'name' => $request->name,
            'contact_email' => $request->contact_email,
            'contact_phone' => $request->contact_phone,
            'address' => $request->address,
            'note' => $request->note,
            'city' => $request->city,
            'province' => $request->province,
            'country_id' => $request->country_id,
            'postal_code' => $request->postal_code,
            'lat' => $request->lat,
            'long' => $request->long,
            'country_code_id' => $request->country_code_id,
        ]);
    }

    function update(Request $request, AddressBook $addressBook)
    {
        $addressBook->update([
            'name' => $request->name,
            'contact_email' => $request->contact_email,
            'contact_phone' => $request->contact_phone,
            'address' => $request->address,
            'note' => $request->note,
            'city' => $request->city,
            'province' => $request->province,
            'country_id' => $request->country_id,
            'postal_code' => $request->postal_code,
            'lat' => $request->lat,
            'long' => $request->long,
            'country_code_id' => $request->country_code_id,
        ]);
    }
}
