<?php

namespace App\Services;

use App\Models\Mailbox;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class DashboardService
{
    public function getUserDashboardCard()
    {

        $unread_messages = Mailbox::where('client_id', auth()->id())->whereNull('is_opened')->count();
        $total_messages = Mailbox::where('client_id', auth()->id())->count();
        $read_messages = $total_messages - $unread_messages;
        return view('app.components.user-dashboard-card', compact('unread_messages', 'total_messages', 'read_messages'))->render();

    }

    public function getAdminDashboardCard()
    {

        $clients = User::where('user_type_id', 1)->count();
        $not_scanned = Mailbox::whereNull('is_scanned')->where('scan_permission', 1)->count();
        $scanned = Mailbox::whereNotNull('is_scanned')->count();
        $pending_attachment = Mailbox::whereNull('is_scanned')->whereNotNull('scan_permission_at')->count();
        $total_mail = Mailbox::count();
        $this_month_mail = Mailbox::whereMonth('created_at', date('m'))->count();
        $last_month_mail = Mailbox::whereMonth('created_at', date('m', strtotime('-1 month')))->count();

        return view('app.components.admin-dashboard-card', compact('clients', 'not_scanned', 'scanned', 'total_mail', 'this_month_mail', 'last_month_mail', 'pending_attachment'))->render();
    }
}
