<?php

namespace App\Services;

use Illuminate\Http\Request;
use Omnipay\Omnipay;


class PaypalService extends SubscriptionService
{
    private $gateway;

    public function __construct()
    {
        $this->gateway = Omnipay::create('PayPal_Rest');
        $this->gateway->setClientId(config('paypal.PK_ID'));
        $this->gateway->setSecret(config('paypal.P_KEY'));
        $this->gateway->setTestMode(true);
    }

    public function payment($invoice)
    {
        try {

            $response = $this->gateway->purchase(array(
                'amount' => $invoice->payable_amount,
                'currency' => config('paypal.P_CURRENCY'),
                'returnUrl' => url('app/paypal/payment-success?invoice_id=' . $invoice->id),
                'cancelUrl' => url('/'),
            ))->send();


            if ($response->isRedirect()) {
                $response->redirect();
            } else {
                return $response->getMessage();
            }
        } catch (\Throwable $th) {
            return $th->getMessage();
        }
    }

    public function success(Request $request)
    {

        if ($request->input('paymentId') && $request->input('PayerID')) {
            $transaction = $this->gateway->completePurchase(array(
                'payer_id' => $request->input('PayerID'),
                'transactionReference' => $request->input('paymentId')
            ));

            $response = $transaction->send();

            if ($response->isSuccessful()) {
                $this->paypalSubscribeSuccess($request->invoice_id);
            } else {
                return $response->getMessage();
            }
        } else {
            return 'Payment declined!!';
        }

        return redirect('app')->with('subscribe-success', 'Payment successful');
    }
}
