<?php

namespace App\Services;

use Stripe\Stripe;
use Stripe\Charge;

class StripeService
{

    public function payment($invoice, $currency = 'usd')
    {
        \Stripe\Stripe::setApiKey(config('stripe.sk'));


        try {
            $session = \Stripe\Checkout\Session::create([
                'line_items'  => [
                    [
                        'price_data' => [
                            'currency'     => 'USD',
                            'product_data' => [
                                "name" => $invoice->servicePackage->package_name,
                            ],
                            'unit_amount'  => $invoice->payable_amount * 100,
                        ],
                        'quantity'   => 1,
                    ],

                ],
                'mode'        => 'payment',
                'success_url' => url('app/stripe/payment-success?invoice_id=' . $invoice->id . '&session_id={CHECKOUT_SESSION_ID}'),
                'cancel_url'  => route('dashboard'),
            ]);

            return redirect($session->url);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()]);
        }
    }
}
