<?php

namespace App\Services;

use App\Models\ServicePackage;
use App\Models\SubscriptionServicePackage;
use Carbon\Carbon;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class SubscriptionService
{

    public function stripeSubscribeSuccess($invoice_id, $payment_details)
    {
        $servicePackage = SubscriptionServicePackage::with(['servicePackage', 'client'])->where('id', $invoice_id)->first();
        $end_date = Auth::user()->sub_end_date ? Carbon::parse(Auth::user()->sub_end_date)->addMonths(1) : Carbon::now()->addMonths(1);


        try {

            DB::beginTransaction();

            SubscriptionServicePackage::where('client_id', $servicePackage->client_id)->update([
                'status' => 'expired',
            ]);

            $servicePackage->update([
                'start_date' => now(),
                'end_date' => $end_date,
                'payment_date' => now(),
                'payment_method' => 'stripe',
                'stripe_invoice_id' => $payment_details['payment_intent'],
                'status' => 'current',
            ]);

            User::where('id', $servicePackage->client_id)->update([
                'sub_start_date' => now(),
                'sub_end_date' => $end_date,
            ]);

            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            return $e->getMessage();
        }
    }

    public function paypalSubscribeSuccess($invoice_id)
    {
        $servicePackage = SubscriptionServicePackage::with(['servicePackage', 'client'])->where('id', $invoice_id)->first();
        $end_date = Carbon::now()->addMonths($servicePackage->no_of_month);
        $servicePackage->update([
            'start_date' => now(),
            'end_date'   => $end_date,
            'payment_date' => now(),
            'payment_method' => 'paypal',
        ]);

        User::where('id', $servicePackage->client_id)->update([
            'sub_start_date' => now(),
            'sub_end_date' => $end_date,
        ]);
    }

    public function subscriptionRenew($data, $end_date, $stripe_subscription_id, $stripe_invoice_id)
    {
        SubscriptionServicePackage::create([
            'spac_id' => $data->spac_id,
            'client_id' => $data->client_id,
            'client_temp_id' => $data->client_temp_id,
            'start_date' => now(),
            'end_date' => $end_date,
            'price' => $data->price,
            'discount' => $data->discount,
            'payable_amount' => $data->payable_amount,
            'invoice_number' => 'INV-' . time(),
            'payment_method' => 'stripe',
            'stripe_subscription_id' => $stripe_subscription_id,
            'stripe_invoice_id' => $stripe_invoice_id,
            'payment_date' => now(),
            'status' => 'current',
        ]);
    }

    public function clientSubscriptionUpdate($client_id, $end_date)
    {
        return SubscriptionServicePackage::where('client_id', $client_id)->update([
            'sub_start_date' => now(),
            'sub_end_date' => $end_date,
        ]);
    }
}
