<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('service_packages', function (Blueprint $table) {
            $table->id();
            $table->unsignedMediumInteger('scat_id');
            $table->string('stripe_product_id')->nullable();
            $table->string('type')->enum('monthly', 'yearly');
            $table->string('package_name');
            $table->unsignedInteger('qty');
            $table->decimal('price', 8, 2);
            $table->tinyInteger('discount')->comment('In percentage');
            $table->text('features')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('service_packages');
    }
};
