<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscription_service_packages', function (Blueprint $table) {
            $table->id();
            $table->unsignedMediumInteger('spac_id');
            $table->unsignedMediumInteger('client_id')->nullable();
            $table->unsignedMediumInteger('client_temp_id');
            $table->dateTime('start_date')->nullable();
            $table->dateTime('end_date')->nullable();
            $table->decimal('price', 8, 2);
            $table->decimal('discount', 8, 2)->nullable();
            $table->unsignedInteger('no_of_month');
            $table->decimal('payable_amount', 8, 2);
            $table->string('invoice_number')->nullable();
            $table->string('payment_method')->nullable();
            $table->string('stripe_subscription_id')->nullable();
            $table->string('stripe_invoice_id')->nullable();
            $table->string('payment_date')->nullable();
            $table->enum('status', ['pending', 'current', 'expired'])->default('pending');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscription_service_packages');
    }
};
