<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mailboxes', function (Blueprint $table) {
            $table->id();
            $table->string('mail_id')->unique();
            $table->foreignId('client_id')->references('id')
                ->on('users')->onDelete('restrict');
            $table->unsignedInteger('spac_id');
            $table->unsignedInteger('ssp_id')->nullable();
            $table->unsignedInteger('mail_from');
            $table->string('title')->nullable();
            $table->text('short_desc')->nullable();
            $table->json('from_mail')->nullable();
            $table->tinyInteger('scan_permission')->default(0)->comment('0: No, 1: Yes');
            $table->dateTime('scan_permission_at')->nullable();
            $table->dateTime('is_scanned')->nullable();
            $table->dateTime('is_opened')->nullable();
            $table->unsignedInteger('forward_to')->nullable();
            $table->unsignedInteger('job_id')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mailboxes');
    }
};
