<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mailbox_attachments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('mailbox_id')->references('id')
                ->on('mailboxes')->onDelete('restrict');
            $table->string('attachment');
            $table->string('attachment_title')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mailbox_attachments');
    }
};
