@extends('app.layouts.app')
@section('title', 'Address Book')
@section('header')
    @include('app.components.datatable-css')
@endsection

@section('content')
    <div class="layout-px-spacing">

        <div class="middle-content container-xxl p-0">

            <div class="page-meta mt-5">
                <nav class="breadcrumb-style-one" aria-label="breadcrumb">
                    <div class="row">
                        <div class="col">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item active" aria-current="page">Address Book</li>
                            </ol>
                        </div>
                        <div class="col text-right d-flex justify-content-end">
                            <button class="btn btn-primary" id="add_item">Add New</button>
                        </div>
                    </div>
                </nav>
            </div>



            <div class="row layout-top-spacing">

                <div class="col-xl-12 col-lg-12 col-sm-12  layout-spacing">
                    <div class="widget-content widget-content-area br-8">

                        <table id="zero-config" class="table dt-table-hover" style="width:100%">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Client</th>
                                    <th>Contact Name</th>
                                    <th>Contact Email</th>
                                    <th>Contact Phone</th>
                                    <th>Note</th>
                                    <th>Address</th>
                                    <th>City</th>
                                    <th>Province</th>
                                    <th>Country</th>
                                    <th>Postal Code</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($records as $item)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $item->client->full_name }}</td>
                                        <td>{{ $item->name }}</td>
                                        <td>{{ $item->contact_email }}</td>
                                        <td>
                                            @if ($item->countryCode && $item->countryCode->country_code && $item->contact_phone)
                                                {{ $item->countryCode->country_code }} {{ $item->contact_phone }}
                                            @endif

                                        </td>
                                        <td>{{ $item->note }}</td>
                                        <td>{{ $item->address }}</td>
                                        <td>{{ $item->city }}</td>
                                        <td>{{ $item->province }}</td>
                                        <td>{{ $item->country->country_name }}</td>

                                        <td>{{ $item->postal_code }}</td>
                                        <td>
                                            <button class="btn-crud" onclick="editItem({{ $item->id }})">
                                                <span class="material-symbols-outlined">
                                                    edit
                                                </span>
                                            </button>


                                            <button class="btn-crud" onclick="deleteItem({{ $item->id }})">
                                                <span class="material-symbols-outlined">
                                                    delete
                                                </span>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="crud_modal"></div>


@endsection

@section('footer')
    @include('app.components.datatable-js')
    <script src="{{ asset('src/ajax.js') }}"></script>

    <script>
        $('#add_item').click(function() {
            ajax_call('get', 'address-book/create').then(function(response) {

                $('#crud_modal').html(response.html)
                $("#exampleModal").modal("show");
            }).catch(function(error) {
                console.error('Error:', error);
            });

        });


        $(document).on('click', '#create', function() {

            if ($('#name').val() == '') {
                error_alert('Address Name is required');
                return;
            }

            if ($('#contact_email').val() == '') {
                error_alert('Contact Email is required');
                return;
            }

            if ($('#contact_phone').val() == '') {
                error_alert('Contact Phone is required');
                return;
            }

            if ($('#address').val() == '') {
                error_alert('Address is required');
                return;
            }

            if ($('#city').val() == '') {
                error_alert('City is required');
                return;
            }

            if ($('#province').val() == '') {
                error_alert('Province is required');
                return;
            }

            if ($('#postal_code').val() == '') {
                error_alert('Postal Code is required');
                return;
            }

            if ($('#country_id').val() == '') {
                error_alert('Country is required');
                return;
            }

            if ($('#country_code_id').val() == '') {
                error_alert('Country Code is required');
                return;
            }

            ajax_call('post', 'address-book', {
                _token: "{{ csrf_token() }}",
                client_id: $('#client_id').val(),
                name: $('#name').val(),
                contact_email: $('#contact_email').val(),
                contact_phone: $('#contact_phone').val(),
                note: $('#note').val(),
                address: $('#address').val(),
                city: $('#city').val(),
                province: $('#province').val(),
                postal_code: $('#postal_code').val(),
                country_id: $('#country_id').val(),
                country_code_id: $('#country_code_id').val(),
            }).then(function(response) {
                console.log(response)
                $("#exampleModal").modal("hide");
                success_alert(response.message);
                setTimeout(function() {
                    window.location.reload();
                }, 3000);
            }).catch(function(error) {
                console.error('Error:', error);
                error_alert(error.responseJSON.message);
                $('#error_message').html('');
                for (const key in error.responseJSON.errors) {
                    if (Object.hasOwnProperty.call(error.responseJSON.errors, key)) {
                        const element = error.responseJSON.errors[key];
                        $('#error_message').append('<div class="alert alert-danger">' + element +
                            '</div>');
                    }
                }
            });
        });

        function deleteItem(id) {
            if (confirm('Are you sure you want to delete this record?')) {
                ajax_call('delete', 'address-book/' + id, {
                    _token: "{{ csrf_token() }}"
                }).then(function(response) {
                    console.log(response)
                    success_alert(response.message);
                    setTimeout(function() {
                        window.location.reload();
                    }, 2000);
                }).catch(function(error) {
                    console.error('Error:', error);
                    error_alert(error.responseJSON.message);
                });
            }
        }

        function editItem(id) {
            $.ajax({
                type: "GET",
                url: "address-book/" + id + "/edit",
                dataType: "JSON",
                success: function(data) {
                    console.log(data)
                    $("#crud_modal").html(data.html);
                    $("#exampleModal").modal("show");
                },
                error(res) {
                    console.log(res)
                }
            });
        }

        $(document).on('click', '#update', function() {
            if ($('#name').val() == '') {
                error_alert('Address Name is required');
                return;
            }


            if ($('#address').val() == '') {
                error_alert('Address is required');
                return;
            }

            if ($('#city').val() == '') {
                error_alert('City is required');
                return;
            }

            if ($('#province').val() == '') {
                error_alert('Province is required');
                return;
            }

            if ($('#postal_code').val() == '') {
                error_alert('Postal Code is required');
                return;
            }

            if ($('#country_id').val() == '') {
                error_alert('Country is required');
                return;
            }



            var id = $('#address_id').val();
            $.ajax({
                type: "PUT",
                url: "address-book/" + id,
                data: {
                    _token: "{{ csrf_token() }}",
                    client_id: $('#client_id').val(),
                    name: $('#name').val(),
                    contact_email: $('#contact_email').val(),
                    contact_phone: $('#contact_phone').val(),
                    note: $('#note').val(),
                    address: $('#address').val(),
                    city: $('#city').val(),
                    province: $('#province').val(),
                    postal_code: $('#postal_code').val(),
                    country_id: $('#country_id').val(),
                    country_code_id: $('#country_code_id').val(),

                },
                dataType: "JSON",
                success: function(data) {
                    console.log(data)
                    $("#exampleModal").modal("hide");
                    success_alert(data.message);
                    setTimeout(function() {
                        window.location.reload();
                    }, 2000);

                },
                error(res) {
                    console.log(res)
                    error_alert(res.responseJSON.message);
                    $('#error_message').html('');
                    for (const key in res.responseJSON.errors) {
                        if (Object.hasOwnProperty.call(res.responseJSON.errors, key)) {
                            const element = res.responseJSON.errors[key];
                            $('#error_message').append('<div class="alert alert-danger">' + element +
                                '</div>');
                        }
                    }
                }
            });
        });
    </script>


@endsection
