<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">
    <title>OTP Verification | Rent a MailBox</title>
    <link rel="stylesheet" href="{{ asset('layouts/modern-light-menu/css/light/loader.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('layouts/modern-light-menu/css/dark/loader.css') }}" type="text/css">
    <script src="{{ asset('layouts/modern-light-menu/loader.js') }}"></script>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:400,600,700">
    <link rel="stylesheet" href="{{ asset('src/bootstrap/css/bootstrap.min.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('layouts/modern-light-menu/css/light/plugins.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('src/assets/css/light/authentication/auth-boxed.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('layouts/modern-light-menu/css/dark/plugins.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('src/assets/css/dark/authentication/auth-boxed.css') }}" type="text/css">

</head>

<body class="form">

    <!-- BEGIN LOADER -->
    <div id="load_screen">
        <div class="loader">
            <div class="loader-content">
                <div class="spinner-grow align-self-center"></div>
            </div>
        </div>
    </div>
    <!--  END LOADER -->

    <div class="auth-container d-flex h-100">

        <div class="container mx-auto align-self-center">

            <div class="row">

                <div class="col-xxl-4 col-xl-5 col-lg-5 col-md-8 col-12 d-flex flex-column align-self-center mx-auto">
                    <div class="card mt-3 mb-3">
                        <div class="card-body">
                            @php
                                $url = url('app/otp-verify?token=' . $token);
                            @endphp
                            <form action="{{ $url }}" method="POST">
                                @csrf
                                <div class="row">


                                    <div class="col-md-12 mb-3">

                                        <h2>OTP Verification</h2>
                                        <p>Please enter the OTP sent to your email</p>
                                        <center>

                                            @if (session('error'))
                                                <p class="text-warning">{{ session('error') }}</p>
                                            @endif

                                        </center>
                                    </div>


                                    <div class="col-sm-2 col-3 ms-auto">
                                        <div class="mb-3">
                                            <input type="text" class="form-control opt-input" name="num1"
                                                id="num1" required>
                                        </div>
                                    </div>
                                    <div class="col-sm-2 col-3">
                                        <div class="mb-3">
                                            <input type="text" class="form-control opt-input" name="num2"
                                                id="num2" required>
                                        </div>
                                    </div>
                                    <div class="col-sm-2 col-3">
                                        <div class="mb-3">
                                            <input type="text" class="form-control opt-input" name="num3"
                                                id="num3" required>
                                        </div>
                                    </div>
                                    <div class="col-sm-2 col-3 me-auto">
                                        <div class="mb-3">
                                            <input type="text" class="form-control opt-input" name="num4"
                                                id="num4" required>
                                        </div>
                                    </div>

                                    <div class="col-12 mt-4">
                                        <div class="mb-4">
                                            <button class="btn btn-secondary w-100">VERIFY</button>
                                        </div>
                                    </div>

                            </form>

                            <div class="col-12">
                                <div class="text-center">
                                    <p class="mb-0">Didn't receive the code ? <a href="javascript:void(0);"
                                            class="text-warning">Resend</a></p>
                                </div>
                            </div>

                        </div>

                    </div>
                </div>
            </div>

        </div>

    </div>

    </div>

    <script src="{{ asset('src/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('src/assets/js/authentication/2-Step-Verification.js') }}"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>

    <script>
        $(document).ready(function() {
            $('#num1').on('input', function() {
                if ($(this).val().length === 4) {
                    var num1 = $(this).val()[0];
                    var num2 = $(this).val()[1];
                    var num3 = $(this).val()[2];
                    var num4 = $(this).val()[3];

                    $(this).val(num1);
                    $('#num2').val(num2).attr('type', 'password');
                    $('#num3').val(num3).attr('type', 'password');
                    $('#num4').val(num4).attr('type', 'password');
                }
            });
        });
    </script>

</body>

</html>
