<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">
    <title>Sign Up | Rent a MailBox</title>

    <link rel="icon" type="image/x-icon" href="{{ asset('favicon-logo.ico') }}" />
    <link href="{{ asset('layouts/modern-light-menu/css/light/loader.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('layouts/modern-light-menu/css/dark/loader.css') }}" rel="stylesheet" type="text/css" />
    <script src="{{ asset('layouts/modern-light-menu/loader.js') }}"></script>

    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700" rel="stylesheet">
    <link href="{{ asset('src/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ asset('layouts/modern-light-menu/css/light/plugins.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('src/assets/css/light/authentication/auth-boxed.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ asset('layouts/modern-light-menu/css/dark/plugins.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('src/assets/css/dark/authentication/auth-boxed.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ asset('src/plugins/css/light/pricing-table/css/component.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('src/plugins/css/dark/pricing-table/css/component.css') }}" rel="stylesheet"
        type="text/css" />


</head>

<body class="form">

    <style>
        .pricing__item {
            border: 1px solid #bfc9d4 !important;
        }
    </style>

    <!-- BEGIN LOADER -->
    <div id="load_screen">
        <div class="loader">
            <div class="loader-content">
                <div class="spinner-grow align-self-center"></div>
            </div>
        </div>
    </div>
    <!--  END LOADER -->

    <div class="auth-container d-flex">

        <div class="container mx-auto align-self-center">

            <div class="row">

                <div class="col-xxl-9 col-xl-9 col-lg-9 col-md-9 col-9 d-flex flex-column align-self-center mx-auto">
                    <div class="card mt-3 mb-3">
                        <div class="card-body">


                            <div class="row">

                                <div class="brand-logo mt-3 mb-5">
                                    <div style="margin-left: 5%">
                                        <a href="{{ url('/') }}"><img src="{{ asset('rent-a-mailbox-logo.png') }}"
                                                alt="" srcset="" width="230"></a>
                                        {{-- {{ env('APP_NAME') }} --}}

                                        <p class="pt-4">
                                            <small>Get a virtual mailbox for your business and personal use. <br> We
                                                provide a physical address for you to receive your mail and
                                                packages.</small>
                                        </p>

                                    </div>
                                </div>

                                @if (session('error'))
                                    <div class="alert alert-danger" role="alert">
                                        {{ session('error') }}
                                    </div>
                                @endif


                                <div class="col-md-6">


                                    @if ($errors->any())
                                        <div class="alert alert-danger" role="alert">
                                            <ul>
                                                @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif


                                    <form action="{{ url('app/register') }}" method="post"
                                        style="padding: 0px 0px 0px 10%">
                                        @csrf

                                        <input type="hidden" name="spac_id" value="{{ $selected_package->id }}">
                                        <input type="hidden" name="duration" value="{{ $duration }}">

                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label class="form-label">Name</label>
                                                <input type="text" class="form-control add-billing-address-input"
                                                    name="full_name" required value="{{ old('full_name') }}">
                                                @if ($errors->has('full_name'))
                                                    <span class="invalid-feedback"
                                                        style="display: block">{{ $errors->first('full_name') }}</span>
                                                @endif

                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="mb-3">
                                                <label class="form-label">Email</label>
                                                <input type="email" class="form-control" name="email" required
                                                    value="{{ old('email') }}">
                                                @if ($errors->has('email'))
                                                    <span class="invalid-feedback"
                                                        style="display: block">{{ $errors->first('email') }}</span>
                                                @endif

                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label class="form-label">Password</label>
                                                <input type="password" class="form-control" name="password" required
                                                    value="{{ old('password') }}">
                                                @if ($errors->has('password'))
                                                    <span
                                                        class="invalid-feedback">{{ $errors->first('password') }}</span>
                                                @endif

                                            </div>
                                        </div>
                                        {{-- <div class="col-12">
                                            <div class="mb-3">
                                                <label class="form-label">Phone</label>
                                                <div class="input-group mb-3">
                                                    <span class="input-group-text">+880</span>
                                                    <input type="number" class="form-control" name="phone_number"
                                                        required id="phone" value="{{ old('phone_number') }}">
                                                    @if ($errors->has('phone_number'))
                                                        <span
                                                            class="invalid-feedback">{{ $errors->first('phone_number') }}</span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div> --}}

                                        <div class="col-12">
                                            <div class="mb-3">
                                                <label class="form-label">Phone</label>
                                                <div class="input-group mb-3">
                                                    <select id="inputState" class="input-group-text" name="country_code_id"
                                                        style="text-align: left">
                                                        @foreach ($country_codes as $item)
                                                            <option value="{{ $item->id }}">
                                                                {{ $item->short_code }} ({{ $item->country_code }})
                                                            </option>
                                                        @endforeach

                                                    </select>
                                                    <input type="number" class="form-control" name="phone_number"
                                                        required id="phone" value="{{ old('phone_number') }}">
                                                    @if ($errors->has('phone_number'))
                                                        <span
                                                            class="invalid-feedback">{{ $errors->first('phone_number') }}</span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>




                                        <div class="col-12">
                                            <div class="mb-3">
                                                <div class="form-check form-check-primary form-check-inline">
                                                    <input class="form-check-input me-3" type="checkbox"
                                                        id="form-check-default" name="condition" required>
                                                    <label class="form-check-label" for="form-check-default">
                                                        I agree the <a href="#" class="text-primary">Terms and
                                                            Conditions</a>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-12">
                                            <div class="mb-4">
                                                <button class="btn btn-secondary w-100">SIGN UP</button>
                                            </div>
                                        </div>
                                    </form>

                                    <div class="col-12">
                                        <div class="text-center">
                                            <p class="mb-0">Already have an account ? <a
                                                    href="{{ url('app/login') }}" class="text-warning">Sign in</a>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    {{-- <div class="col-md-12 mb-3">
                                        <h2>GOLD</h2>
                                        <p class="m-0">* Duration: {{ session('duration') }} month</p>
                                        <p>* Price: {{ session('price') }}</p>


                                    </div>
                                    <p class="text-center">Enter your information to register</p> --}}

                                    <section class="pricing-section bg-7" style="margin-top: 0px">
                                        <div class="pricing pricing--norbu">
                                            <div class="pricing__item">
                                                <h3 class="pricing__title">
                                                    {{ $selected_package->package_name }} |
                                                    <small>{{ $selected_package->serviceCategory->service_category_name }}</small>
                                                </h3>

                                                <div class="pricing__price"><span class="pricing__currency">$</span>
                                                    {{ $grand_total }}<span
                                                        class="pricing__period">/{{ $duration }} month</span>
                                                </div>
                                                <ul class="pricing__feature-list text-center">
                                                    <li class="pricing__feature">
                                                        You got {{ $discount_percentage }}% discount!
                                                    </li>
                                                    <li class="pricing__feature">
                                                        Subscription End Date: {{ DT($expected_end_date) }}
                                                    </li>
                                                    <br>
                                                    <small>
                                                        After registration, you will be able to pay for the package.
                                                    </small>

                                                </ul>
                                            </div>

                                        </div>
                                    </section>


                                </div>




                            </div>

                        </div>
                    </div>
                </div>

            </div>

        </div>

    </div>

    <!-- BEGIN GLOBAL MANDATORY SCRIPTS -->
    <script src="{{ asset('src/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <!-- END GLOBAL MANDATORY SCRIPTS -->
    <script>
        document.getElementById("phone").addEventListener("input", function() {
            // Remove any non-digit characters
            this.value = this.value.replace(/\D/g, '');

            // Ensure length is exactly 10 characters
            if (this.value.length > 10) {
                this.value = this.value.slice(0, 10); // Limiting input to 10 characters
            }
        });
    </script>
</body>

</html>
