<div class="row">
    <div class="col-md-5">

        @include('app.components.client-profile', ['user' => $mail_details['user']])

    </div>
    <div class="col-md-7">

        <div class="card">
            <div class="card-body">
                <div class="" style="margin-bottom: 50px">
                    <div class="row mb-3">
                        <label for="full_name" class="col col-form-label">Title</label>
                        <p>
                            {{ $mail_details['mail']['title'] }}
                        </p>
                    </div>
                    <div class="row mb-3">
                        <label for="full_name" class="col col-form-label">Short Description</label>
                        <p>
                            {{ $mail_details['mail']['short_desc'] }}
                        </p>
                    </div>


                    <div class="row">
                        <label for="full_name" class="col-sm-3 col-form-label">Attachment</label>
                        <div class="col d-flex align-items-center">

                            @if ($mail_details['mail']['attachment'])

                            @php
                                $info = pathinfo($mail_details['mail']['attachment']);
                                $filename = $info['filename'];
                            @endphp

                                <a target="_blank"
                                     href="{{ url('app/download-attachment/'.$filename) }}"> Download</a>
                            @else
                                <div class="row">
                                    <div class="col">
                                        <input type="file" name="attachment" id="attachment"
                                            class="form-control-file" accept=".pdf">
                                    </div>
                                    <div class="col">
                                        <input type="hidden" name="mail_id" id="mail_id"
                                            value="{{ $mail_details['mail']['id'] }}">
                                        <button class="btn btn-primary" onclick="fileUpload()">Upload</button>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                    <div class="row">
                        <label for="full_name" class="col-sm-3 col-form-label">Scan Permission</label>
                        <div class="col  d-flex align-items-center">


                            @if ($mail_details['mail']['scan_permission'] == 1)
                                Yes
                            @else
                                No
                            @endif

                        </div>
                    </div>
                    <div class="row">
                        <label for="full_name" class="col-sm-3 col-form-label">Is Scanned </label>
                        <div class="col  d-flex align-items-center">
                            {{ $mail_details['mail']['is_scanned'] }}
                        </div>
                    </div>
                    <div class="row">
                        <label for="full_name" class="col-sm-3 col-form-label">Is Opened </label>
                        <div class="col  d-flex align-items-center">
                            {{ $mail_details['mail']['is_opened'] }}
                        </div>
                    </div>
                </div>


                <div class="row mt-3">
                    <div class="" style="margin-bottom: 10px">

                        <div class="row">
                            <label class="col-sm-3 col-form-label">Mail From</label>
                            <div class="col d-flex align-items-center">
                                <p>
                                    {{ $mail_details['address']['name'] }}
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <label class="col-sm-3 col-form-label">Contact Email</label>
                            <div class="col d-flex align-items-center">
                                <p>
                                    {{ $mail_details['address']['contact_email'] }}
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <label class="col-sm-3 col-form-label">Contact Phone</label>
                            <div class="col d-flex align-items-center">
                                <p>
                                    {{ $mail_details['address']['country_phone_code'] }}
                                    {{ $mail_details['address']['contact_phone'] }}
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <label class="col-sm-3 col-form-label">Note</label>
                            <div class="col d-flex align-items-center">
                                <p>
                                    {{ $mail_details['address']['note'] }}
                                </p>
                            </div>
                        </div>


                        <div class="row">
                            <label class="col-sm-3 col-form-label">Address</label>
                            <div class="col d-flex align-items-center">
                                <p>
                                    {{ $mail_details['address']['address'] }}
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <label class="col-sm-3 col-form-label">City</label>
                            <div class="col d-flex align-items-center">
                                <p>
                                    {{ $mail_details['address']['city'] }}
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <label class="col-sm-3 col-form-label">Province</label>
                            <div class="col d-flex align-items-center">
                                <p>
                                    {{ $mail_details['address']['province'] }}
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <label class="col-sm-3 col-form-label">Country</label>
                            <div class="col d-flex align-items-center">
                                <p>
                                    {{ $mail_details['address']['country_name'] }}
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <label class="col-sm-3 col-form-label">Postal Code</label>
                            <div class="col d-flex align-items-center">
                                <p>
                                    {{ $mail_details['address']['postal_code'] }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<script>
    function fileUpload() {
        // Create a FormData object to handle file upload
        var formData = new FormData();
        formData.append('_token', "{{ csrf_token() }}");
        formData.append('mail_id', $('#mail_id').val());
        formData.append('attachment', $('#attachment')[0].files[0]); // Append the file

        // Perform the AJAX request
        $.ajax({
            url: 'upload-mail-attachment',
            type: 'POST',
            data: formData,
            contentType: false, // Required for FormData object
            processData: false, // Required for FormData object
            success: function(response) {
                success_alert(response.message);
                $("#exampleModal").modal("hide");
            },
            error: function(error) {
                    error_alert(error.responseJSON.message);
            }
        });
    }
</script>
