<div class="row">
    <div class="col-md-5">

        @include('app.components.client-profile', ['user' => $user])

    </div>
    <div class="col-md-7">

        <form action="{{ url('app/mail-entry-submit') }}" method="post" enctype="multipart/form-data" id="mail-entry-form">
            @csrf

            <input type="hidden" name="user_id" value="{{ $user->id }}">
            <input type="hidden" name="spac_id" value="{{ $user->spac_id }}">

            <div class="card">
                <div class="card-body">
                    <div class="" style="margin-bottom: 50px">
                        <div class="row mb-3">
                            <label for="full_name" class="col-sm-2 col-form-label">Title</label>
                            <div class="col">
                                <input type="text" class="form-control" id="title" name="title" value=""
                                    required="">
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="full_name" class="col-sm-2 col-form-label">Short Description</label>
                            <div class="col">
                                <textarea class="form-control" id="short_desc" name="short_desc" cols="30" rows="2"></textarea>
                            </div>
                        </div>


                        <div class="row mb-3">
                            <label for="full_name" class="col-sm-2 col-form-label">Attachment</label>
                            <div class="col">
                                @if ($user->scan_permission == 1)
                                    <input type="file" accept=".pdf" class="form-control-file" id="attachment"
                                        name="attachment" required="">
                                    <input type="hidden" name="scan_permission" value="1">
                                @else
                                    <input type="hidden" name="scan_permission" value="0">
                                    <span class="text-danger">
                                        <i>
                                            * Send a scan request to the client
                                        </i>
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>


                    <div class="row mt-3">
                        <div class="" style="margin-bottom: 10px">
                            <div class="row mb-3">
                                <label for="full_name" class="col-sm-2 col-form-label">Mail From</label>
                                <div class="col">
                                    <select class="form-select" id="address_id" name="address_id"
                                        onchange="getAddress(this.value)">
                                        <option selected value="0">Select Address</option>
                                        @foreach ($address_book as $item)
                                            <option value="{{ $item->id }}">{{ $item->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="row mb-3">
                                <label for="full_name" class="col-sm-4 col-form-label">Contact Name<span
                                        class="text-danger">*</span></label>
                                <div class="col">
                                    <input type="text" class="form-control input-address" id="name"
                                        value="" name="name" required="">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label for="qty" class="col-sm-4 col-form-label">Contact
                                    Email<span class="text-danger"></span></label>
                                <div class="col">
                                    <input type="email" class="form-control input-address" id="contact_email"
                                        name="contact_email" value="" >
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="qty" class="col-sm-4 col-form-label">Contact
                                    Phone<span class="text-danger"></span></label>
                                {{-- <div class="col">
                                    <input type="number" class="form-control input-address" id="contact_phone"
                                        name="contact_phone" value="" required="">
                                </div> --}}

                                <div class="col">
                                    <select class="form-control input-address" name="country_code_id" id="country_code_id"
                                        style="text-align: left">
                                        <option value="" selected>Select Country Code</option>
                                        @foreach ($country as $item)
                                            <option value="{{ $item->id }}">
                                                {{ $item->short_code }} ({{ $item->country_code }})
                                            </option>
                                        @endforeach
                                    </select>

                                    <input type="number" class="form-control mt-2 input-address" name="contact_phone"
                                        id="contact_phone" placeholder="Phone Number">
                                </div>
                            </div>


                            <div class="row mb-3">
                                <label for="qty" class="col-sm-4 col-form-label">Note</label>
                                <div class="col">
                                    <input type="text" class="form-control input-address" id="note"
                                        name="note" value="">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row mb-3">
                                <label for="qty" class="col-sm-4 col-form-label">Address<span
                                        class="text-danger">*</span></label>
                                <div class="col">
                                    <input type="text" class="form-control input-address" id="address"
                                        name="address" value="" required="">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label for="qty" class="col-sm-4 col-form-label">City<span
                                        class="text-danger">*</span></label>
                                <div class="col">
                                    <input type="text" class="form-control input-address" id="city"
                                        name="city" value="" required="">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label for="qty" class="col-sm-4 col-form-label">Province/State<span
                                        class="text-danger">*</span></label>
                                <div class="col">
                                    <input type="text" class="form-control input-address" id="province"
                                        name="province" value="" required="">
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="qty" class="col-sm-4 col-form-label">Country<span
                                        class="text-danger">*</span></label>
                                <div class="col">
                                    <select type = "text" class="form-control input-address" id="country_id" name="country_id" required>
                                        @foreach ($country as $item)
                                            <option value="{{ $item->id }}">
                                                {{ $item->country_name }}</option>
                                        @endforeach

                                    </select>

                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="qty" class="col-sm-4 col-form-label">Postal Code<span
                                        class="text-danger">*</span></label>
                                <div class="col">
                                    <input type="text" class="form-control input-address" id="postal_code"
                                        name="postal_code" required="">
                                </div>
                            </div>
                        </div>


                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>

                </div>
            </div>
        </form>
    </div>
</div>

<script>
    function getAddress(id) {

        if (id == 0) {
            $('.input-address').val('');
            $('.input-address').attr('readonly', false);
            return;
        }

        var end_point = 'address-book/' + id;

        ajax_call('get', end_point).then(function(response) {

        console.log(response.data);

            $('#name').val(response.data.name);
            $('#contact_email').val(response.data.contact_email);
            $('#country_code_id').val(response.data.country_code_id);
            $('#contact_phone').val(response.data.contact_phone);
            $('#note').val(response.data.note);
            $('#address').val(response.data.address);
            $('#city').val(response.data.city);
            $('#province').val(response.data.province);
            $('#country_id').val(response.data.country_id);
            $('#postal_code').val(response.data.postal_code);
            $('.input-address').attr('readonly', true);

        }).catch(function(error) {
            console.log(error);
        });
    }

    // $('#mail-entry-form').on('submit', function(e) {
    //     e.preventDefault();

    //     alert('Form Submitted');
    // });
</script>
