<div class="col-xl-9">

    <div class="invoice-container">
        <div class="invoice-inbox">

            <div id="ct" class="">

                <div class="invoice-00001">
                    <div class="content-section">

                        <div class="inv--head-section inv--detail-section">

                            <div class="row">

                                <div class="col-sm-6 col-12 mr-auto">
                                    <div class="d-flex">
                                        <img class="company-logo" src="{{ asset('rent-a-mailbox-512x512.png') }}"
                                            alt="company">
                                        <h3 class="in-heading align-self-center">
                                            {{ env('COMPANY_NAME') }}</h3>
                                    </div>
                                    <p class="inv-street-addr mt-3">
                                        {{ env('COMPANY_NAME') }}
                                    </p>
                                    <p class="inv-email-address">
                                        {{ env('COMPANY_EMAIL') }}
                                    </p>
                                    <p class="inv-email-address">
                                        {{ env('COMPANY_PHONE') }}
                                    </p>
                                </div>

                                <div class="col-sm-6 text-sm-end">
                                    <p class="inv-list-number mt-sm-3 pb-sm-2 mt-4">
                                        <span class="inv-title">Invoice : </span>
                                        <span class="inv-number">#{{ $invoice->invoice_number }}</span>
                                        </span>
                                    </p>
                                    <p class="inv-created-date mt-sm-5 mt-3"><span class="inv-title">Invoice Date :
                                        </span> <span class="inv-date">
                                            {{ date('d M Y', strtotime($invoice->created_at)) }}
                                        </span></p>

                                </div>
                            </div>

                        </div>

                        <div class="inv--detail-section inv--customer-detail-section">

                            <div class="row">

                                <div class="col-xl-8 col-lg-7 col-md-6 col-sm-4 align-self-center">
                                    <p class="inv-to">Invoice To</p>
                                </div>

                                <div
                                    class="col-xl-4 col-lg-5 col-md-6 col-sm-8 align-self-center order-sm-0 order-1 text-sm-end mt-sm-0 mt-5">
                                    <h6 class=" inv-title">Invoice From</h6>
                                </div>

                                <div class="col-xl-8 col-lg-7 col-md-6 col-sm-4">
                                    <p class="inv-customer-name">
                                        {{ $invoice->client->full_name }}
                                    </p>

                                    <p class="inv-email-address">
                                        {{ $invoice->client->email }}
                                    </p>
                                    <p class="inv-email-address">
                                        {{ $invoice->client->phone_number }}
                                    </p>
                                </div>

                                <div class="col-xl-4 col-lg-5 col-md-6 col-sm-8 col-12 order-sm-0 order-1 text-sm-end">
                                    <p class="inv-customer-name">
                                        {{ env('COMPANY_NAME') }}
                                    </p>
                                    <p class="inv-street-addr">
                                        {{ env('COMPANY_ADDRESS') }}
                                    </p>
                                    <p class="inv-email-address">
                                        {{ env('COMPANY_EMAIL') }}
                                    </p>
                                    <p class="inv-email-address">
                                        {{ env('COMPANY_PHONE') }}
                                    </p>
                                </div>

                            </div>

                        </div>

                        <div class="inv--product-table-section">
                            <div class="table-responsive">
                                <table class="table">
                                    <thead class="">
                                        <tr>
                                            <th scope="col">S.No</th>
                                            <th scope="col">
                                                Package Name
                                            </th>
                                            <th scope="col">
                                                Category
                                            </th>
                                            <th class="text-end" scope="col">
                                                No of Month
                                            </th>
                                            <th class="text-end" scope="col">
                                                Qty
                                            </th>
                                            <th class="text-end" scope="col">
                                                Price
                                            </th>
                                            <th class="text-end" scope="col">
                                                 Discount
                                            </th>
                                            <th class="text-end" scope="col">
                                                Amount
                                            </th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>1</td>
                                            <td>
                                                {{ $invoice->servicePackage->package_name }}
                                            </td>
                                            <td class="">
                                                {{ $invoice->servicePackage->serviceCategory->service_category_name }}
                                            </td>
                                            <td class="text-end">
                                                {{ $invoice->no_of_month }}
                                            </td>
                                            <td class="text-end">
                                                {{ $invoice->servicePackage->qty }}
                                            </td>
                                            <td class="text-end">
                                                ${{ $invoice->price }}
                                            </td>
                                            <td class="text-end">
                                                ${{ $invoice->discount }}
                                            </td>
                                            <td class="text-end">
                                                ${{ $invoice->payable_amount }}
                                            </td>

                                        </tr>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="inv--total-amounts">

                            <div class="row mt-4">
                                <div class="col-sm-5 col-12 order-sm-0 order-1">
                                </div>
                                <div class="col-sm-7 col-12 order-sm-1 order-0">
                                    <div class="text-sm-end">
                                        <div class="row">
                                            <div class="col-sm-8 col-7">
                                                <p class="">Sub Total :</p>
                                            </div>
                                            <div class="col-sm-4 col-5">
                                                <p class="">
                                                    ${{ $invoice->payable_amount }}
                                                </p>
                                            </div>
                                            <div class="col-sm-8 col-7">
                                                <p class="">Tax 0% :</p>
                                            </div>
                                            <div class="col-sm-4 col-5">
                                                <p class="">
                                                    $0
                                                </p>
                                            </div>
                                            <div class="col-sm-8 col-7">
                                                <p class="">
                                                    <b>
                                                        Grand Total
                                                    </b>
                                                    :
                                                </p>
                                            </div>
                                            <div class="col-sm-4 col-5">
                                                <p class="">
                                                    <b>
                                                        ${{ $invoice->payable_amount }}
                                                    </b>
                                                </p>
                                            </div>

                                            @if ($invoice->payment_date)
                                                <h2 class="text-success mt-4">(Paid)</h2>
                                                <p>
                                                    Payment Date: {{ date('d M Y', strtotime($invoice->payment_date)) }}
                                                </p>
                                            @else
                                                <h2 class="text-danger mt-4">(Unpaid)</h2>
                                            @endif



                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="inv--note">

                            <div class="row mt-4">
                                <div class="col-sm-12 col-12 order-sm-0 order-1">
                                    <p>Note: Thank you for using our service.</p>
                                    </p>
                                </div>
                            </div>

                        </div>

                    </div>
                </div>

            </div>


        </div>

    </div>

</div>
