@extends('app.layouts.app')
@section('title', 'Invoice Details')
@section('header')
    <link rel="stylesheet" href="{{ asset('src/assets/css/light/apps/invoice-preview.css') }}" type="text/css">
    <link rel="stylesheet" href="{{ asset('src/assets/css/dark/apps/invoice-preview.css') }}" type="text/css">
@endsection

@section('content')
    <div class="layout-px-spacing">

        <div class="middle-content container-xxl p-0">

            <div class="page-meta mt-5">
                <nav class="breadcrumb-style-one" aria-label="breadcrumb">
                    <div class="row">
                        <div class="col">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item active" aria-current="page">Invoice Details</li>
                            </ol>
                        </div>
                        <div class="col text-right d-flex justify-content-end">
                        </div>
                    </div>
                </nav>
            </div>


            <div class="row invoice layout-top-spacing layout-spacing">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

                    <div class="doc-container">

                        <div class="row">


                            {!! $html !!}

                            <div class="col-xl-3">

                                @if ($invoice->payment_date)
                                    <div class="invoice-actions-btn">

                                        <div class="invoice-action-btn">

                                            <div class="row">

                                                <div class="col-xl-12 col-md-3 col-sm-6">
                                                    <a href="javascript:void(0);"
                                                        class="btn btn-secondary btn-print action-print _effect--ripple waves-effect waves-light">Print</a>
                                                </div>

                                            </div>

                                        </div>

                                    </div>
                                @else
                                    <form action="{{ url('app/make-payment') }}" method="POST">
                                        @csrf

                                        <input type="hidden" name="invoice_id" value="{{ $invoice->id }}">

                                        <div class="card">
                                            <div class="card-body">
                                                <h5 class="card-title">Payment Method</h5>
                                                <p> Now we are accepting payment through Stripe. Click the button
                                                    below to
                                                    make payment. </p>
                                                <div class="row mt-4 mb-3">

                                                    <div class="col-md-6">
                                                        <div class="input-group">
                                                            <div class="input-group-text payment-radio">
                                                                <input class="form-check-input mt-0 " type="radio"
                                                                    name="payment_method" value="stripe"
                                                                    aria-label="Radio button for following text input"
                                                                    checked>

                                                            </div>
                                                            <img src="{{ asset('src/assets/images/stripe.jpg') }}"
                                                                class="align-self-center me-3 payment-method-icon"
                                                                alt="stripe">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        {{-- <div class="input-group">
                                                            <div class="input-group-text payment-radio">
                                                                <input class="form-check-input mt-0 " type="radio"
                                                                    name="payment_method" value="paypal"
                                                                    aria-label="Radio button for following text input">

                                                            </div>
                                                            <img src="{{ asset('src/assets/images/paypal.jpg') }}"
                                                                class="align-self-center me-3 payment-method-icon"
                                                                alt="stripe">
                                                        </div> --}}
                                                    </div>



                                                </div>

                                                <button
                                                    class="btn btn-primary mb-2 me-4 mt-4 _effect--ripple waves-effect waves-light">Make
                                                    Payment</button>
                                            </div>
                                        </div>

                                    </form>
                                @endif

                            </div>

                        </div>

                    </div>

                </div>
            </div>
        </div>
    </div>



@endsection

@section('footer')
    <script src="{{ asset('src/assets/js/apps/invoice-preview.js') }}"></script>

@endsection
