@extends('app.layouts.app')
@section('title', 'Invoice History')
@section('header')
    @include('app.components.datatable-css')
@endsection

@section('content')
    <div class="layout-px-spacing">

        <div class="middle-content container-xxl p-0">

            <div class="page-meta mt-5">
                <nav class="breadcrumb-style-one" aria-label="breadcrumb">
                    <div class="row">
                        <div class="col">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item active" aria-current="page">Invoice History</li>
                            </ol>
                        </div>
                        <div class="col text-right d-flex justify-content-end">
                        </div>
                    </div>
                </nav>
            </div>



            <div class="row layout-top-spacing">

                <div class="col-xl-12 col-lg-12 col-sm-12  layout-spacing">
                    <div class="widget-content widget-content-area br-8">

                        <table id="zero-config" class="table dt-table-hover" style="width:100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Invoice Number</th>
                                    <th>Client Name</th>
                                    <th>Service</th>
                                    <th>Amount</th>
                                    <th>Payment Status</th>
                                    <th>Payment Date</th>

                                    <th class="no-content">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($invoices as $item)
                                    <tr id="item_{{ $item->id }}">
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $item->invoice_number }}</td>
                                        <td>{{ $item->client->full_name }} ({{ $item->client->user_id }})</td>
                                        <td>{{ $item->servicePackage->package_name }},
                                            {{ $item->servicePackage->serviceCategory->service_category_name }}</td>
                                        <td>{{ $item->payable_amount }}</td>
                                        <td>
                                            @if ($item->payment_date)
                                                <span class="badge badge-success">Paid</span>
                                            @else
                                                <span class="badge badge-danger">Unpaid</span>
                                            @endif

                                        </td>
                                        <td>
                                            @if ($item->payment_date)
                                                {{ DT($item->payment_date) }}
                                            @endif
                                        </td>

                                        <td>
                                            <a href="{{ url('app/invoice/' . $item->invoice_number) }}">
                                                <span class="material-symbols-outlined">
                                                    visibility
                                                </span>
                                            </a>

                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>



@endsection

@section('footer')
    @include('app.components.datatable-js')



@endsection
