@extends('app.layouts.app')
@section('title', 'Service Packages')
@section('header')
    @include('app.components.datatable-css')
@endsection

@section('content')
    <div class="layout-px-spacing">

        <div class="middle-content container-xxl p-0">

            <div class="page-meta mt-5">
                <nav class="breadcrumb-style-one" aria-label="breadcrumb">
                    <div class="row">
                        <div class="col">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item active" aria-current="page">Service Package</li>
                            </ol>
                        </div>
                        <div class="col text-right d-flex justify-content-end">
                            <button class="btn btn-primary" id="add_item">Add New</button>
                        </div>
                    </div>
                </nav>
            </div>



            <div class="row layout-top-spacing">

                <div class="col-xl-12 col-lg-12 col-sm-12  layout-spacing">
                    <div class="widget-content widget-content-area br-8">

                        <table id="zero-config" class="table dt-table-hover" style="width:100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Package Name</th>
                                    <th>Service Category</th>
                                    <th>Type</th>
                                    <th>Qunatity</th>
                                    <th>Price</th>
                                    <th>Discount</th>
                                    <th class="no-content">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($servicePackages as $item)
                                    <tr id="item_{{ $item->id }}">
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $item->package_name }}</td>
                                        <td>{{ $item->serviceCategory->service_category_name }}</td>
                                        <td>{{ $item->type }}</td>
                                        <td>{{ $item->qty }}</td>
                                        <td>{{ $item->price }}</td>
                                        <td>{{ $item->discount }}%</td>
                                        <td>
                                            <button class="btn-crud" onclick="editItem({{ $item->id }})">
                                                <span class="material-symbols-outlined">
                                                    edit
                                                </span>
                                            </button>

                                            <button class="btn-crud" onclick="deleteItem({{ $item->id }})">
                                                <span class="material-symbols-outlined">
                                                    delete
                                                </span>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="crud_modal"></div>


@endsection

@section('footer')
    @include('app.components.datatable-js')

    <script>
        $('#add_item').click(function() {
            $.ajax({
                type: "GET",
                url: "service-package/create",
                dataType: "JSON",
                success: function(data) {
                    console.log(data)
                    $("#crud_modal").html(data.html);
                    $("#exampleModal").modal("show");
                },
                error(res) {
                    console.log(res)
                }
            });
        });



        $(document).on('click', '#create', function() {

            $.ajax({
                type: "POST",
                url: "service-package",
                data: {
                    _token: "{{ csrf_token() }}",
                    scat_id: $('#service_category_id').val(),
                    package_name: $('#package_name').val(),
                    qty: $('#qty').val(),
                    price: $('#price').val(),
                    discount: $('#discount').val(),
                    type: $('#type').val(),
                    features: $('#features').val(),
                },
                dataType: "JSON",
                success: function(data) {
                    console.log(data)
                    $("#exampleModal").modal("hide");
                    success_alert(data.message);
                    setTimeout(function() {
                        window.location.reload();
                    }, 3000);

                },
                error(res) {
                    console.log(res)
                    error_alert(res.responseJSON.message);
                    $('#error_message').html('');
                    for (const key in res.responseJSON.errors) {
                        if (Object.hasOwnProperty.call(res.responseJSON.errors, key)) {
                            const element = res.responseJSON.errors[key];
                            $('#error_message').append('<div class="alert alert-danger">' + element +
                                '</div>');
                        }
                    }
                }
            });
        });

        function deleteItem(id) {

            if (confirm("Are you sure you want to delete this item?")) {
                $.ajax({
                    type: "DELETE",
                    url: "service-package/" + id,
                    data: {
                        _token: "{{ csrf_token() }}",
                    },
                    dataType: "JSON",
                    success: function(data) {
                        console.log(data);
                        success_alert(data.message);
                        $('#item_' + id).remove();

                    },
                    error: function(res) {
                        console.log(res);
                        error_alert(res.responseJSON.message);
                    }
                });
            }
        }

        function editItem(id) {
            $.ajax({
                type: "GET",
                url: "service-package/" + id + "/edit",
                dataType: "JSON",
                success: function(data) {
                    console.log(data)
                    $("#crud_modal").html(data.html);
                    $("#exampleModal").modal("show");
                },
                error(res) {
                    console.log(res)
                }
            });
        }

        $(document).on('click', '#update', function() {
            var id = $('#service_package_id').val();
            $.ajax({
                type: "PUT",
                url: "service-package/" + id,
                data: {
                    _token: "{{ csrf_token() }}",
                    scat_id: $('#service_category_id').val(),
                    package_name: $('#package_name').val(),
                    qty: $('#qty').val(),
                    price: $('#price').val(),
                    discount: $('#discount').val(),
                    type: $('#type').val(),
                    features: $('#features').val(),
                },
                dataType: "JSON",
                success: function(data) {
                    console.log(data)
                    $("#exampleModal").modal("hide");
                    success_alert(data.message);
                    setTimeout(function() {
                        window.location.reload();
                    }, 3000);

                },
                error(res) {
                    console.log(res)
                    error_alert(res.responseJSON.message);
                    $('#error_message').html('');
                    for (const key in res.responseJSON.errors) {
                        if (Object.hasOwnProperty.call(res.responseJSON.errors, key)) {
                            const element = res.responseJSON.errors[key];
                            $('#error_message').append('<div class="alert alert-danger">' + element +
                                '</div>');
                        }
                    }
                }
            });
        });
    </script>

@endsection
