@extends('app.layouts.app')
@section('title', Auth::user()->full_name)
@section('header')


    <link rel="stylesheet" href="{{ asset('src/plugins/src/filepond/filepond.min.css') }}">
    <link rel="stylesheet" href="{{ asset('src/plugins/src/filepond/FilePondPluginImagePreview.min.css') }}">
    <link href="{{ asset('src/plugins/src/notification/snackbar/snackbar.min.css') }}" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="{{ asset('src/plugins/src/sweetalerts2/sweetalerts2.css') }}">
    <link href="{{ asset('src/plugins/css/light/filepond/custom-filepond.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('src/assets/css/light/components/tabs.css') }}" rel="stylesheet" type="text/css">
    <link rel="stylesheet" type="text/css" href="{{ asset('src/assets/css/light/elements/alert.css') }}">
    <link href="{{ asset('src/plugins/css/light/sweetalerts2/custom-sweetalert.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('src/plugins/css/light/notification/snackbar/custom-snackbar.css') }}" rel="stylesheet"
        type="text/css" />
    <link rel="stylesheet" type="text/css" href="{{ asset('src/assets/css/light/forms/switches.css') }}">
    <link href="{{ asset('src/assets/css/light/components/list-group.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('src/assets/css/light/users/account-setting.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('src/plugins/css/dark/filepond/custom-filepond.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('src/assets/css/dark/components/tabs.css') }}" rel="stylesheet" type="text/css">
    <link rel="stylesheet" type="text/css" href="{{ asset('src/assets/css/dark/elements/alert.css') }}">
    <link href="{{ asset('src/plugins/css/dark/sweetalerts2/custom-sweetalert.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('src/plugins/css/dark/notification/snackbar/custom-snackbar.css') }}" rel="stylesheet"
        type="text/css" />
    <link rel="stylesheet" type="text/css" href="{{ asset('src/assets/css/dark/forms/switches.css') }}">
    <link href="{{ asset('src/assets/css/dark/components/list-group.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('src/assets/css/dark/users/account-setting.css') }}" rel="stylesheet" type="text/css" />




@endsection

@section('content')


    <div class="layout-px-spacing">

        <div class="middle-content container-xxl p-0">

            <!-- BREADCRUMB -->
            <div class="page-meta">
                <nav class="breadcrumb-style-one" aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Users</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Account Settings</li>
                    </ol>
                </nav>
            </div>
            <!-- /BREADCRUMB -->

            <div class="account-settings-container layout-top-spacing">




                <div class="account-content">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <h2>Settings</h2>

                            <ul class="nav nav-pills" id="animateLine" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="animated-underline-home-tab" data-bs-toggle="tab"
                                        href="#animated-underline-home" role="tab"
                                        aria-controls="animated-underline-home" aria-selected="true"><svg
                                            xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round" class="feather feather-home">
                                            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                                            <polyline points="9 22 9 12 15 12 15 22"></polyline>
                                        </svg> Profile</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="animated-underline-profile-tab" data-bs-toggle="tab"
                                        href="#animated-underline-profile" role="tab"
                                        aria-controls="animated-underline-profile" aria-selected="false"
                                        tabindex="-1"><svg xmlns="http://www.w3.org/2000/svg" width="24"
                                            height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                            stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                            class="feather feather-dollar-sign">
                                            <line x1="12" y1="1" x2="12" y2="23"></line>
                                            <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path>
                                        </svg> Subscription Details</button>
                                </li>

                            </ul>
                        </div>
                    </div>

                    <div class="tab-content" id="animateLineContent-4">
                        <div class="tab-pane fade active show" id="animated-underline-home" role="tabpanel"
                            aria-labelledby="animated-underline-home-tab">
                            <div class="row">
                                <div class="col-xl-6 col-lg-6 col-md-6 layout-spacing">
                                    <form class="section general-info" method="post" enctype="multipart/form-data"
                                        action="{{ url('app/setting/profile/update') }}">
                                        @csrf
                                        <div class="info">
                                            <h6 class="">General Information</h6>
                                            <div class="row">
                                                <div class="col-lg-11 mx-auto">
                                                    <div class="row">

                                                        <input type="hidden" name="id"
                                                            value="{{ $user->id }}">

                                                        <div class="col-xl-12 col-lg-12 col-md-12 mt-md-0 mt-4">
                                                            <div class="form">
                                                                <div class="row">
                                                                    <div class="col-md-12">
                                                                        <div class="form-group">
                                                                            <label for="fullName">Full Name</label>
                                                                            <input type="text" class="form-control"
                                                                                name="full_name" placeholder="Full Name"
                                                                                value="{{ $user->full_name }}" required>

                                                                            @error('full_name')
                                                                                <span class="text-danger">
                                                                                    <i>
                                                                                        {{ $message }}
                                                                                    </i>
                                                                                </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>



                                                                    <div class="col-md-6">
                                                                        <div class="form-group">
                                                                            <label for="email"
                                                                                class="mt-3">Email</label>
                                                                            <input type="text"
                                                                                class="form-control mb-3" id="email"
                                                                                placeholder="Write your email here"
                                                                                value="{{ $user->email }}" readonly>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <div class="form-group">
                                                                            <label for="phone"
                                                                                class="mt-3">Phone</label>
                                                                            <input type="text"
                                                                                class="form-control mb-3"
                                                                                value="{{ $user->country_code->country_code }} {{ $user->phone_number }}"
                                                                                readonly>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <div class="form-group">
                                                                            <label for="website1"
                                                                                class="mt-3">Password</label>
                                                                            <input type="password"
                                                                                class="form-control mb-3" name="password"
                                                                                required>
                                                                            @error('confirm_password')
                                                                                <span class="text-danger">
                                                                                    <i>
                                                                                        {{ $message }}
                                                                                    </i>
                                                                                </span>
                                                                            @enderror
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <div class="form-group">
                                                                            <label for="website1" class="mt-3">Confirm
                                                                                Password</label>
                                                                            <input type="password"
                                                                                class="form-control mb-3"
                                                                                name="confirm_password" required>
                                                                        </div>
                                                                    </div>



                                                                    <div class="col-md-12 mt-1">
                                                                        <div class="form-group text-end">
                                                                            <button
                                                                                class="btn btn-secondary _effect--ripple waves-effect waves-light">Save</button>
                                                                        </div>
                                                                    </div>

                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="col-xl-4 col-lg-12 col-md-12 layout-spacing">
                                    <div class="section general-info">
                                        <div class="info">
                                            <h6 class="">Mail Scan Permission</h6>
                                            <p>
                                                You can use this section to set the permission to scan your mail.
                                            </p>
                                            <div class="col-sm-12 mt-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="gridRadios"
                                                        @if ($user->scan_permission == 1) checked @endif id="gridRadios1"
                                                        value="option1">
                                                    <label class="form-check-label" for="gridRadios1"
                                                        onclick="updateScanPermission(1)">
                                                        Allowed scan
                                                    </label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="gridRadios"
                                                        @if ($user->scan_permission == 0) checked @endif id="gridRadios2"
                                                        value="option2">
                                                    <label class="form-check-label" for="gridRadios2"
                                                        onclick="updateScanPermission(0)">
                                                        Every time ask for scan
                                                    </label>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="tab-pane fade" id="animated-underline-profile" role="tabpanel"
                            aria-labelledby="animated-underline-profile-tab">
                            <div class="row">


                                <div class="col-xl-6 col-lg-12 col-md-12 layout-spacing">
                                    <div class="section general-info payment-info">
                                        <div class="info">
                                            <h6 class="">Current Subscription</h6>
                                            <p>
                                                    Your current subscription package is <strong>{{ $package->package_name }}</strong> and the expiry date is <strong>{{ DT($user->sub_end_date) }}</strong>

                                            </p>

                                            <div class="list-group mt-4">


                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-xl-6 col-lg-12 col-md-12 layout-spacing">

                                    </div>

                                </div>
                            </div>



                        </div>
                    </div>

                </div>

            </div>

        </div>

    </div>
@endsection


@section('footer')

    <script src="{{ asset('src/plugins/src/filepond/filepond.min.js') }}"></script>
    <script src="{{ asset('src/plugins/src/filepond/FilePondPluginFileValidateType.min.js') }}"></script>
    <script src="{{ asset('src/plugins/src/filepond/FilePondPluginImageExifOrientation.min.js') }}"></script>
    <script src="{{ asset('src/plugins/src/filepond/FilePondPluginImagePreview.min.js') }}"></script>
    <script src="{{ asset('src/plugins/src/filepond/FilePondPluginImageCrop.min.js') }}"></script>
    <script src="{{ asset('src/plugins/src/filepond/FilePondPluginImageResize.min.js') }}"></script>
    <script src="{{ asset('src/plugins/src/filepond/FilePondPluginImageTransform.min.js') }}"></script>
    <script src="{{ asset('src/plugins/src/filepond/filepondPluginFileValidateSize.min.js') }}"></script>
    <script src="{{ asset('src/plugins/src/notification/snackbar/snackbar.min.js') }}"></script>
    <script src="{{ asset('src/plugins/src/sweetalerts2/sweetalerts2.min.js') }}"></script>
    <script src="{{ asset('src/assets/js/users/account-settings.js') }}"></script>
    <script src="{{ asset('src/ajax.js') }}"></script>
    <script>
        function updateScanPermission(permission) {
            var data = {
                _token: "{{ csrf_token() }}",
                permission: permission,
            };


            ajax_call('post', 'profile/update-scan-permission', data).then(function(response) {
                success_alert(response.message);
            }).catch(function(error) {
                console.error('Error:', error);
            });


        }
    </script>



@endsection
