<div class="row">
    <div class="col-md-5">

        <?php echo $__env->make('app.components.client-profile', ['user' => $user], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>
    <div class="col-md-7">

        <form action="<?php echo e(url('app/mail-entry-submit')); ?>" method="post" enctype="multipart/form-data" id="mail-entry-form">
            <?php echo csrf_field(); ?>

            <input type="hidden" name="user_id" value="<?php echo e($user->id); ?>">
            <input type="hidden" name="spac_id" value="<?php echo e($user->spac_id); ?>">

            <div class="card">
                <div class="card-body">
                    <div class="" style="margin-bottom: 50px">
                        <div class="row mb-3">
                            <label for="full_name" class="col-sm-2 col-form-label">Title</label>
                            <div class="col">
                                <input type="text" class="form-control" id="title" name="title" value=""
                                    required="">
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="full_name" class="col-sm-2 col-form-label">Short Description</label>
                            <div class="col">
                                <textarea class="form-control" id="short_desc" name="short_desc" cols="30" rows="2"></textarea>
                            </div>
                        </div>


                        <div class="row mb-3">
                            <label for="full_name" class="col-sm-2 col-form-label">Attachment</label>
                            <div class="col">
                                <?php if($user->scan_permission == 1): ?>
                                    <input type="file" accept=".pdf" class="form-control-file" id="attachment"
                                        name="attachment" required="">
                                    <input type="hidden" name="scan_permission" value="1">
                                <?php else: ?>
                                    <input type="hidden" name="scan_permission" value="0">
                                    <span class="text-danger">
                                        <i>
                                            * Send a scan request to the client
                                        </i>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>


                    <div class="row mt-3">
                        <div class="" style="margin-bottom: 10px">
                            <div class="row mb-3">
                                <label for="full_name" class="col-sm-2 col-form-label">Mail From</label>
                                <div class="col">
                                    <select class="form-select" id="address_id" name="address_id"
                                        onchange="getAddress(this.value)">
                                        <option selected value="0">Select Address</option>
                                        <?php $__currentLoopData = $address_book; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="row mb-3">
                                <label for="full_name" class="col-sm-4 col-form-label">Contact Name<span
                                        class="text-danger">*</span></label>
                                <div class="col">
                                    <input type="text" class="form-control input-address" id="name"
                                        value="" name="name" required="">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label for="qty" class="col-sm-4 col-form-label">Contact
                                    Email<span class="text-danger"></span></label>
                                <div class="col">
                                    <input type="email" class="form-control input-address" id="contact_email"
                                        name="contact_email" value="" >
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="qty" class="col-sm-4 col-form-label">Contact
                                    Phone<span class="text-danger"></span></label>
                                

                                <div class="col">
                                    <select class="form-control input-address" name="country_code_id" id="country_code_id"
                                        style="text-align: left">
                                        <option value="" selected>Select Country Code</option>
                                        <?php $__currentLoopData = $country; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>">
                                                <?php echo e($item->short_code); ?> (<?php echo e($item->country_code); ?>)
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <input type="number" class="form-control mt-2 input-address" name="contact_phone"
                                        id="contact_phone" placeholder="Phone Number">
                                </div>
                            </div>


                            <div class="row mb-3">
                                <label for="qty" class="col-sm-4 col-form-label">Note</label>
                                <div class="col">
                                    <input type="text" class="form-control input-address" id="note"
                                        name="note" value="">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row mb-3">
                                <label for="qty" class="col-sm-4 col-form-label">Address<span
                                        class="text-danger">*</span></label>
                                <div class="col">
                                    <input type="text" class="form-control input-address" id="address"
                                        name="address" value="" required="">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label for="qty" class="col-sm-4 col-form-label">City<span
                                        class="text-danger">*</span></label>
                                <div class="col">
                                    <input type="text" class="form-control input-address" id="city"
                                        name="city" value="" required="">
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label for="qty" class="col-sm-4 col-form-label">Province/State<span
                                        class="text-danger">*</span></label>
                                <div class="col">
                                    <input type="text" class="form-control input-address" id="province"
                                        name="province" value="" required="">
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="qty" class="col-sm-4 col-form-label">Country<span
                                        class="text-danger">*</span></label>
                                <div class="col">
                                    <select type = "text" class="form-control input-address" id="country_id" name="country_id" required>
                                        <?php $__currentLoopData = $country; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>">
                                                <?php echo e($item->country_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>

                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="qty" class="col-sm-4 col-form-label">Postal Code<span
                                        class="text-danger">*</span></label>
                                <div class="col">
                                    <input type="text" class="form-control input-address" id="postal_code"
                                        name="postal_code" required="">
                                </div>
                            </div>
                        </div>


                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>

                </div>
            </div>
        </form>
    </div>
</div>

<script>
    function getAddress(id) {

        if (id == 0) {
            $('.input-address').val('');
            $('.input-address').attr('readonly', false);
            return;
        }

        var end_point = 'address-book/' + id;

        ajax_call('get', end_point).then(function(response) {

        console.log(response.data);

            $('#name').val(response.data.name);
            $('#contact_email').val(response.data.contact_email);
            $('#country_code_id').val(response.data.country_code_id);
            $('#contact_phone').val(response.data.contact_phone);
            $('#note').val(response.data.note);
            $('#address').val(response.data.address);
            $('#city').val(response.data.city);
            $('#province').val(response.data.province);
            $('#country_id').val(response.data.country_id);
            $('#postal_code').val(response.data.postal_code);
            $('.input-address').attr('readonly', true);

        }).catch(function(error) {
            console.log(error);
        });
    }

    // $('#mail-entry-form').on('submit', function(e) {
    //     e.preventDefault();

    //     alert('Form Submitted');
    // });
</script>
<?php /**PATH /home/ferdous-ahmed-khan/Project/rent-a-mailbox/resources/views/app/mailbox/mail-entry-form.blade.php ENDPATH**/ ?>