<?php $__env->startSection('title', 'Mailbox'); ?>
<?php $__env->startSection('header'); ?>
    <?php echo $__env->make('app.components.datatable-css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    

    <link href="<?php echo e(asset('src/assets/css/light/apps/mailbox.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('src/assets/css/dark/apps/mailbox.css')); ?>" rel="stylesheet" type="text/css" />


<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="layout-px-spacing">

        <div class="middle-content container-xxl p-0">

            <div class="row layout-top-spacing">
                <div class="col-xl-12 col-lg-12 col-md-12">

                    <div class="row">

                        <div class="col-xl-12  col-md-12">

                            <div class="mail-box-container">

                                <div class="mail-overlay"></div>


                                <div id="mailbox-inbox" class="accordion mailbox-inbox">

                                    <div class="search">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="feather feather-menu mail-menu d-lg-none">
                                            <line x1="3" y1="12" x2="21" y2="12"></line>
                                            <line x1="3" y1="6" x2="21" y2="6"></line>
                                            <line x1="3" y1="18" x2="21" y2="18"></line>
                                        </svg>
                                        <input type="text" class="form-control input-search" placeholder="Search Here..."
                                            value="<?php echo e(request()->search); ?>">
                                    </div>



                                    <div class="message-box">

                                        <div class="message-box-scroll ps ps--active-y" id="ct">


                                            <?php $__currentLoopData = $mail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(!$item->is_opened): ?>
                                                    <div id="unread-promotion-page" class="mail-item mailInbox"
                                                        style="" onclick="openMail(<?php echo e($item->id); ?>)">
                                                        <div class="animated animatedFadeInUp fadeInUp"
                                                            id="mailHeadingThree">
                                                            <div class="mb-0">
                                                                <div class="mail-item-heading social collapsed"
                                                                    data-bs-toggle="collapse" role="navigation"
                                                                    data-bs-target="#mailCollapseThree"
                                                                    aria-expanded="false">
                                                                    <div class="mail-item-inner">

                                                                        <div class="d-flex">
                                                                            <div class="f-head">
                                                                                <img src="<?php echo e(asset('src/assets/images/user-profile.jpg')); ?>"
                                                                                    class="user-profile" alt="avatar">
                                                                            </div>
                                                                            <div class="f-body">
                                                                                <div class="meta-mail-time">
                                                                                    <p class="user-email"
                                                                                        data-mailto="laurieFox@mail.com">
                                                                                        <?php echo e($item->addressBook->name); ?>

                                                                                    </p>
                                                                                </div>
                                                                                <div class="meta-title-tag">
                                                                                    <p class="mail-content-excerpt"
                                                                                        data-maildescription="{&quot;ops&quot;:[{&quot;insert&quot;:&quot;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi pulvinar feugiat consequat. Duis lacus nibh, sagittis id varius vel, aliquet non augue. Vivamus sem ante, ultrices at ex a, rhoncus ullamcorper tellus. Nunc iaculis eu ligula ac consequat. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum mattis urna neque, eget posuere lorem tempus non. Suspendisse ac turpis dictum, convallis est ut, posuere sem. Etiam imperdiet aliquam risus, eu commodo urna vestibulum at. Suspendisse malesuada lorem eu sodales aliquam.\n&quot;}]}">

                                                                                        <?php if($item->attachment): ?>
                                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                                width="24"
                                                                                                height="24"
                                                                                                viewBox="0 0 24 24"
                                                                                                fill="none"
                                                                                                stroke="currentColor"
                                                                                                stroke-width="2"
                                                                                                stroke-linecap="round"
                                                                                                stroke-linejoin="round"
                                                                                                class="feather feather-paperclip attachment-indicator">
                                                                                                <path
                                                                                                    d="M21.44 11.05l-9.19 9.19a6 6 0 0 1-8.49-8.49l9.19-9.19a4 4 0 0 1 5.66 5.66l-9.2 9.19a2 2 0 0 1-2.83-2.83l8.49-8.48">
                                                                                                </path>
                                                                                            </svg>
                                                                                        <?php endif; ?>


                                                                                        <span class="mail-title"
                                                                                            data-mailtitle="Promotion Page">
                                                                                            <?php echo e($item->title); ?>

                                                                                        </span>
                                                                                        <?php echo e(Str::limit($item->short_desc, 80)); ?>


                                                                                    </p>

                                                                                    <p>
                                                                                        <?php echo e($item->mail_id); ?>

                                                                                    </p>

                                                                                    <p class="meta-time align-self-center">
                                                                                        <?php echo e($item->created_at); ?>

                                                                                    </p>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php else: ?>
                                                    <div id="read-promotion-page" class="mail-item mailInbox" style=""
                                                        onclick="openMail(<?php echo e($item->id); ?>)">
                                                        <div class="animated animatedFadeInUp fadeInUp"
                                                            id="mailHeadingThree">
                                                            <div class="mb-0">
                                                                <div class="mail-item-heading social collapsed"
                                                                    data-bs-toggle="collapse" role="navigation"
                                                                    data-bs-target="#mailCollapseThree"
                                                                    aria-expanded="false">
                                                                    <div class="mail-item-inner">

                                                                        <div class="d-flex">
                                                                            <div class="f-head">
                                                                                <img src="<?php echo e(asset('src/assets/images/user-profile.jpg')); ?>"
                                                                                    class="user-profile" alt="avatar">
                                                                            </div>
                                                                            <div class="f-body">
                                                                                <div class="meta-mail-time">
                                                                                    <p class="user-email"
                                                                                        data-mailto="laurieFox@mail.com">

                                                                                        <?php echo e($item->addressBook->name); ?>

                                                                                    </p>
                                                                                </div>
                                                                                <div class="meta-title-tag">
                                                                                    <p class="mail-content-excerpt"
                                                                                        data-maildescription="{&quot;ops&quot;:[{&quot;insert&quot;:&quot;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi pulvinar feugiat consequat. Duis lacus nibh, sagittis id varius vel, aliquet non augue. Vivamus sem ante, ultrices at ex a, rhoncus ullamcorper tellus. Nunc iaculis eu ligula ac consequat. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum mattis urna neque, eget posuere lorem tempus non. Suspendisse ac turpis dictum, convallis est ut, posuere sem. Etiam imperdiet aliquam risus, eu commodo urna vestibulum at. Suspendisse malesuada lorem eu sodales aliquam.\n&quot;}]}">
                                                                                        <?php if($item->attachment): ?>
                                                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                                                width="24"
                                                                                                height="24"
                                                                                                viewBox="0 0 24 24"
                                                                                                fill="none"
                                                                                                stroke="currentColor"
                                                                                                stroke-width="2"
                                                                                                stroke-linecap="round"
                                                                                                stroke-linejoin="round"
                                                                                                class="feather feather-paperclip attachment-indicator">
                                                                                                <path
                                                                                                    d="M21.44 11.05l-9.19 9.19a6 6 0 0 1-8.49-8.49l9.19-9.19a4 4 0 0 1 5.66 5.66l-9.2 9.19a2 2 0 0 1-2.83-2.83l8.49-8.48">
                                                                                                </path>
                                                                                            </svg>
                                                                                        <?php endif; ?>
                                                                                        <span style="margin-right:20px ">
                                                                                            <?php echo e($item->mail_id); ?>

                                                                                        </span>
                                                                                        <span class="mail-title" style="margin-right:10px "
                                                                                            data-mailtitle="Promotion Page">

                                                                                            <?php echo e($item->title); ?>

                                                                                        </span>

                                                                                        <?php echo e($item->short_desc); ?>


                                                                                    </p>

                                                                                    <p class="meta-time align-self-center">
                                                                                        <?php echo e($item->created_at); ?>

                                                                                    </p>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            <?php if(count($mail) == 0): ?>
                                                <div class="alert alert-light-danger alert-dismissible fade show border-0 m-4 text-center"
                                                    role="alert">
                                                    <button type="button" class="btn-close"><svg> ... </svg></button>

                                                    <?php if(request()->search): ?>
                                                        <strong>No mail found for "<?php echo e(request()->search); ?>"</strong>
                                                    <?php else: ?>
                                                        <strong>Sorry!</strong> No mail found.
                                                    <?php endif; ?>

                                                    </button>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <span class="d-flex justify-content-end">
                                            <?php echo e($mail->links()); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </div>
    <script src="<?php echo e(asset('src/assets/js/apps/mailbox.js')); ?>"></script>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
    <!-- Add this to the <head> section of your layout file -->

    <script>
        function openMail(id) {
            var endpoint = "<?php echo e(url('app/mailbox/')); ?>/" + id;
            window.location.href = endpoint;
        }

        $(document).ready(function() {
            $('.input-search').on('keypress', function(e) {
                if (e.which == 13) { // 13 is the keycode for Enter key
                    var search = $(this).val();
                    var url = "<?php echo e(url('app/mailbox')); ?>?search=" + search;
                    window.location.href = url;
                }
            });

        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('app.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ferdous-ahmed-khan/Project/rent-a-mailbox/resources/views/app/mailbox/index.blade.php ENDPATH**/ ?>