<?php $__env->startSection('title', 'Invoice History'); ?>
<?php $__env->startSection('header'); ?>
    <?php echo $__env->make('app.components.datatable-css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="layout-px-spacing">

        <div class="middle-content container-xxl p-0">

            <div class="page-meta mt-5">
                <nav class="breadcrumb-style-one" aria-label="breadcrumb">
                    <div class="row">
                        <div class="col">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item active" aria-current="page">Invoice History</li>
                            </ol>
                        </div>
                        <div class="col text-right d-flex justify-content-end">
                        </div>
                    </div>
                </nav>
            </div>



            <div class="row layout-top-spacing">

                <div class="col-xl-12 col-lg-12 col-sm-12  layout-spacing">
                    <div class="widget-content widget-content-area br-8">

                        <table id="zero-config" class="table dt-table-hover" style="width:100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Invoice Number</th>
                                    <th>Client Name</th>
                                    <th>Service</th>
                                    <th>Amount</th>
                                    <th>Payment Status</th>
                                    <th>Payment Date</th>

                                    <th class="no-content">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr id="item_<?php echo e($item->id); ?>">
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($item->invoice_number); ?></td>
                                        <td><?php echo e($item->client->full_name); ?> (<?php echo e($item->client->user_id); ?>)</td>
                                        <td><?php echo e($item->servicePackage->package_name); ?>,
                                            <?php echo e($item->servicePackage->serviceCategory->service_category_name); ?></td>
                                        <td><?php echo e($item->payable_amount); ?></td>
                                        <td>
                                            <?php if($item->payment_date): ?>
                                                <span class="badge badge-success">Paid</span>
                                            <?php else: ?>
                                                <span class="badge badge-danger">Unpaid</span>
                                            <?php endif; ?>

                                        </td>
                                        <td>
                                            <?php if($item->payment_date): ?>
                                                <?php echo e(DT($item->payment_date)); ?>

                                            <?php endif; ?>
                                        </td>

                                        <td>
                                            <a href="<?php echo e(url('app/invoice/' . $item->invoice_number)); ?>">
                                                <span class="material-symbols-outlined">
                                                    visibility
                                                </span>
                                            </a>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
    <?php echo $__env->make('app.components.datatable-js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('app.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ferdous-ahmed-khan/Project/rent-a-mailbox/resources/views/app/payment/invoice-history.blade.php ENDPATH**/ ?>