<?php $__env->startSection('title', 'Mail Detail'); ?>
<?php $__env->startSection('header'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('src/assets/css/light/widgets/modules-widgets.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('src/assets/css/dark/widgets/modules-widgets.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="layout-px-spacing">

        <div class="middle-content container-xxl p-0">


            <div class="card layout-top-spacing">
                <div class="widget widget-card-one">



                    <div class="row">
                        <div class="col-md-8">
                            <div class="widget-content" style="padding: 20px 0 20px 20px">
                                <div class="media">
                                    <div class="w-img">
                                        <img src="<?php echo e(asset('src/assets/images/user-profile.jpg')); ?>" alt="avatar">
                                    </div>
                                    <div class="media-body">
                                        <h6>
                                            <?php echo e($mail_details['address']['name']); ?>

                                        </h6>
                                        <p class="meta-date-time">

                                            <span>
                                                <?php echo e($mail_details['mail']->created_at->format('d M Y')); ?>

                                            </span>


                                        </p>
                                    </div>
                                </div>


                                <p>
                                    Tracking ID: <?php echo e($mail_details['mail']->mail_id); ?>

                                    <br>
                                    <br>

                                    <b>
                                        <?php echo e($mail_details['mail']->title); ?>

                                    </b>
                                    <br>
                                    <br>

                                    <?php echo e($mail_details['mail']->short_desc); ?>

                                </p>


                                <div class="w-action mb-2" style="border-bottom:1px dashed #e0e6ed">
                                    <h5 class="mb-2">Attachments</h5>
                                </div>
                                <div class="w-action mb-2" id="attachment_area">

                                    <?php if($mail_details['mail']->attachment): ?>


                                    <?php
                                        $info = pathinfo($mail_details['mail']->attachment);
                                        $filename = $info['filename'];
                                    ?>

                                        <a target="_blank"
                                            
                                            
                                            href="<?php echo e(url('app/download-attachment', $filename)); ?>"
                                            class="d-flex align-items-center">
                                            <svg xmlns="http://www.w3.org/2000/svg" height="48px" viewBox="0 -960 960 960"
                                                width="48px" fill="#5f6368">
                                                <path
                                                    d="M331-431h37v-83h48q15.73 0 26.36-10.64Q453-535.28 453-551v-48q0-15.72-10.64-26.36Q431.73-636 416-636h-85v205Zm37-120v-48h48v48h-48Zm129 120h84q15 0 26-10.64 11-10.63 11-26.36v-131q0-15.72-11-26.36Q596-636 581-636h-84v205Zm37-37v-131h47v131h-47Zm133 37h37v-83h50v-37h-50v-48h50v-37h-87v205ZM260-200q-24 0-42-18t-18-42v-560q0-24 18-42t42-18h560q24 0 42 18t18 42v560q0 24-18 42t-42 18H260Zm0-60h560v-560H260v560ZM140-80q-24 0-42-18t-18-42v-620h60v620h620v60H140Zm120-740v560-560Z" />
                                            </svg>
                                            <span class="ms-2">
                                                <?php echo e($mail_details['mail']->attachment_title); ?>

                                        </a>
                                    <?php elseif($mail_details['mail']->scan_permission_at): ?>
                                        <p>
                                            Scan Permission Granted. Please wait for the attachment.
                                        </p>
                                    <?php elseif($mail_details['mail']->scan_permission == 0): ?>
                                        <p>Your scan permission is off. You can send permission to scan the attachment to
                                            authority for this mail. <br>
                                            <button class="btn btn-primary mb-2 me-4 mt-2 btn-sm"
                                                onclick="sendScanRequest(<?php echo e($mail_details['mail']->id); ?> )">Send
                                                Request</button>
                                        </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">

                            <div class="mb-2 mt-4" style="padding: 0 20px">

                                <h5>
                                    Mail From
                                </h5>

                                <div class="d-flex align-items-center mt-3">
                                    <span class="material-symbols-outlined me-2">
                                        person
                                    </span>
                                    <label class="col col-form-label ">
                                        <?php echo e($mail_details['address']['name']); ?>

                                    </label>
                                </div>
                                <div class="d-flex align-items-center">
                                    <span class="material-symbols-outlined me-2">
                                        email
                                    </span>
                                    <label class="col col-form-label ">
                                        <?php echo e($mail_details['address']['contact_email']); ?>

                                    </label>
                                </div>
                                <div class="d-flex align-items-center">
                                    <span class="material-symbols-outlined me-2">
                                        phone
                                    </span>
                                    <label class="col col-form-label ">
                                        <?php echo e($mail_details['address']['country_phone_code']); ?>

                                        <?php echo e($mail_details['address']['contact_phone']); ?>

                                    </label>
                                </div>
                                <div class="d-flex align-items-center">
                                    <span class="material-symbols-outlined me-2">
                                        <span class="material-symbols-outlined">
                                            home
                                        </span>
                                    </span>
                                    <label class="col col-form-label ">
                                        <?php echo e($mail_details['address']['address']); ?>, <?php echo e($mail_details['address']['city']); ?>

                                        -
                                        <?php echo e($mail_details['address']['postal_code']); ?>

                                    </label>
                                </div>


                                <div class="d-flex align-items-center">
                                    <span class="material-symbols-outlined me-2">
                                        location_on
                                    </span>
                                    <label class="col col-form-label ">
                                        <?php echo e($mail_details['address']['province']); ?>,
                                        <?php echo e($mail_details['address']['country_name']); ?>

                                    </label>
                                </div>

                            </div>
                        </div>
                    </div>



                </div>
            </div>

        </div>
    </div>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>


    <script src="<?php echo e(asset('src/ajax.js')); ?>"></script>

    <script>
        function sendScanRequest(id) {
            var data = {
                id: id,
                _token: '<?php echo e(csrf_token()); ?>'
            }
            var endpoint = "mail-scan-permission";

            $.ajax({
                type: "POST",
                url: endpoint,
                dataType: "JSON",
                data: data,
                success: function(data, textStatus, xhr) {
                    success_alert(data.message);
                    $('#attachment_area').html('<p>Scan Permission Granted. Please wait for the attachment.</p>');
                },
                error: function(res, status, error) {
                    // error_alert(res.responseJSON.message);
                    console.error('Error:', res);
                },
            });



        }
    </script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('app.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ferdous-ahmed-khan/Project/rent-a-mailbox/resources/views/app/mailbox/mail-detail-client.blade.php ENDPATH**/ ?>