<?php $__env->startSection('title', 'Client List'); ?>
<?php $__env->startSection('header'); ?>
    <?php echo $__env->make('app.components.datatable-css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="layout-px-spacing">

        <div class="middle-content container-xxl p-0">

            <div class="page-meta mt-5">
                <nav class="breadcrumb-style-one" aria-label="breadcrumb">
                    <div class="row">
                        <div class="col">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item active" aria-current="page">Client List</li>
                            </ol>
                        </div>
                        <div class="col text-right d-flex justify-content-end">
                        </div>
                    </div>
                </nav>
            </div>



            <div class="row layout-top-spacing">

                <div class="col-xl-12 col-lg-12 col-sm-12  layout-spacing">
                    <div class="widget-content widget-content-area br-8">

                        <table id="zero-config" class="table dt-table-hover" style="width:100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone Number</th>
                                    <th>Package</th>
                                    <th>Subscription</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr id="item_<?php echo e($item->id); ?>">
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($item->full_name); ?> (<?php echo e($item->user_id); ?>)</td>
                                        <td><?php echo e($item->email); ?></td>
                                        <td><?php echo e($item->phone_number); ?></td>
                                        <td><?php echo e($item->package->package_name); ?>,
                                            <?php echo e($item->package->serviceCategory->service_category_name); ?></td>
                                        <td>
                                            <?php if($item->sub_start_date): ?>
                                                <?php echo e(DT($item->sub_start_date)); ?> - <?php echo e(DT($item->sub_end_date)); ?>

                                            <?php else: ?>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <button class="btn-crud" onclick="viewItem(<?php echo e($item->id); ?>)">
                                                <span class="material-symbols-outlined">
                                                    visibility
                                                </span>
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content" id="">

                <div class="modal-body" id="profile_details">
                    


                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
    <?php echo $__env->make('app.components.datatable-js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script src="<?php echo e(asset('src/ajax.js')); ?>"></script>

    <script>
        function viewItem(id) {
            ajax_call('get', 'client-profile-modal/' + id).then(function(response) {
                console.log(response)
                $('#profile_details').html(response.html)
                $("#exampleModal").modal("show");
            }).catch(function(error) {
                console.error('Error:', error);
            });

        }
    </script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('app.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ferdous-ahmed-khan/Project/rent-a-mailbox/resources/views/app/users/client-list.blade.php ENDPATH**/ ?>