<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">
    <title>Welcome to Rent A Mailbox</title>
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('favicon-logo.ico')); ?>" />

    <link rel="stylesheet" href="<?php echo e(asset('layouts/modern-light-menu/css/light/loader.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('layouts/modern-light-menu/css/dark/loader.css')); ?>" type="text/css">
    <script src="<?php echo e(asset('layouts/modern-light-menu/loader.js')); ?>"></script>
    <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('src/bootstrap/css/bootstrap.min.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('layouts/modern-light-menu/css/light/plugins.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('layouts/modern-light-menu/css/dark/plugins.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('src/assets/css/light/apps/invoice-preview.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('src/assets/css/dark/apps/invoice-preview.css')); ?>" type="text/css">
    <link rel="stylesheet" href="<?php echo e(asset('scss/style.css')); ?>" type="text/css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('src/plugins/src/stepper/bsStepper.min.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('src/assets/css/light/scrollspyNav.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('src/plugins/css/light/stepper/custom-bsStepper.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('src/assets/css/dark/scrollspyNav.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('src/plugins/css/dark/stepper/custom-bsStepper.css')); ?>" />
</head>

<body class="layout-boxed" data-bs-spy="scroll" data-bs-target="#navSection" data-bs-offset="100">

    <!-- BEGIN LOADER -->
    <div id="load_screen">
        <div class="loader">
            <div class="loader-content">
                <div class="spinner-grow align-self-center"></div>
            </div>
        </div>
    </div>


    <div class="header-container container-xxl" style="left: 0">
        <header class="header navbar navbar-expand-sm expand-header">

            <a href="javascript:void(0);" class="sidebarCollapse">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                    stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                    class="feather feather-menu">
                    <line x1="3" y1="12" x2="21" y2="12"></line>
                    <line x1="3" y1="6" x2="21" y2="6"></line>
                    <line x1="3" y1="18" x2="21" y2="18"></line>
                </svg>
            </a>

            <div class="search-animated">
                <a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(asset('rent-a-mailbox-logo.png')); ?>" style="width: 200px"
                        alt=""></a>
            </div>

            <ul class="navbar-item flex-row ms-lg-auto ms-0">


                <li class="nav-item dropdown user-profile-dropdown  order-lg-0 order-1">
                    <a href="javascript:void(0);" class="nav-link dropdown-toggle user" id="userProfileDropdown"
                        data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <div class="avatar-container">
                            <div class="avatar avatar-sm avatar-indicators avatar-online">
                                <img alt="avatar" src="<?php echo e(asset('src/assets/images/user-profile.jpg')); ?>"
                                    class="rounded-circle">
                            </div>
                        </div>
                    </a>

                    <div class="dropdown-menu position-absolute" aria-labelledby="userProfileDropdown">
                        <div class="user-profile-section">
                            <div class="media mx-auto">
                                <div class="media-body">
                                    <h5><?php echo e(Auth::user()->full_name); ?></h5>
                                </div>
                            </div>
                        </div>

                        <div class="dropdown-item">
                            <a href="<?php echo e(url('app/logout')); ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round" class="feather feather-log-out">
                                    <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"></path>
                                    <polyline points="16 17 21 12 16 7"></polyline>
                                    <line x1="21" y1="12" x2="9" y2="12"></line>
                                </svg> <span>Log Out</span>
                            </a>
                        </div>
                    </div>
                </li>
            </ul>
        </header>
    </div>

    <div class="main-container " id="container">

        <div class="overlay"></div>
        <div class="search-overlay"></div>


        <div id="content" class="main-content" style="margin: 100px 0px 0px 0px">
            <div class="container">
                <div class="container-fluid">

                    <div class="row layout-top-spacing" id="cancel-row">

                        <div id="wizard_Default" class="col-lg-12 layout-spacing">
                            <div class="statbox widget box box-shadow">
                                <div class="widget-header">
                                    <div class="row">
                                        <div class="col-xl-12 col-md-12 col-sm-12 col-12">
                                            <h4>Welcome to Rent A Mailbox</h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="widget-content widget-content-area">
                                    <div class="bs-stepper stepper-form-one">
                                        <div class="bs-stepper-header" role="tablist">
                                            <div class="step" data-target="#defaultStep-one">
                                                <button type="button" class="step-trigger" role="tab">
                                                    <span class="bs-stepper-circle">1</span>
                                                    <span class="bs-stepper-label">Step One</span>
                                                </button>
                                            </div>
                                            <div class="line"></div>
                                            <div class="step" data-target="#defaultStep-two">
                                                <button type="button" class="step-trigger" role="tab">
                                                    <span class="bs-stepper-circle">2</span>
                                                    <span class="bs-stepper-label">Step Two</span>
                                                </button>
                                            </div>
                                            <div class="line"></div>
                                            <div class="step" data-target="#defaultStep-three">
                                                <button type="button" class="step-trigger" role="tab">
                                                    <span class="bs-stepper-circle">3</span>
                                                    <span class="bs-stepper-label">
                                                        <span class="bs-stepper-title">Step Three</span>
                                                    </span>
                                                </button>
                                            </div>
                                        </div>
                                        <div class="bs-stepper-content">
                                            <div id="defaultStep-one" class="content " role="tabpanel">

                                                <div class="d-flex justify-content-center m-5">
                                                    <div class="section general-info col ">
                                                        <div class="info">
                                                            <h6 class="text-center">Mail Scan Permission</h6>
                                                            <p class="text-center">
                                                                You can use this section to set the permission to scan
                                                                your
                                                                mail.
                                                            </p>

                                                            <div class="d-flex justify-content-center">
                                                                <div class="col-md-3 mt-3">
                                                                    <div class="form-check">
                                                                        <input class="form-check-input" type="radio"
                                                                            name="gridRadios" id="gridRadios1"
                                                                            <?php echo e(Auth::user()->scan_permission == 1 ? 'checked' : ''); ?>

                                                                            value="option1">
                                                                        <label class="form-check-label"
                                                                            for="gridRadios1"
                                                                            onclick="updateScanPermission(1)">
                                                                            Allowed scan
                                                                        </label>
                                                                    </div>
                                                                    <div class="form-check">
                                                                        <input class="form-check-input" type="radio"
                                                                        <?php echo e(Auth::user()->scan_permission == 0 ? 'checked' : ''); ?>

                                                                            name="gridRadios" id="gridRadios2"
                                                                            value="option2">
                                                                        <label class="form-check-label"
                                                                            for="gridRadios2"
                                                                            onclick="updateScanPermission(0)">
                                                                            Every time ask for scan
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>




                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="button-action mt-5">
                                                    <button class="btn btn-secondary btn-prev me-3"
                                                        disabled>Prev</button>
                                                    <button class="btn btn-secondary btn-nxt">Next</button>
                                                </div>
                                            </div>
                                            <div id="defaultStep-two" class="content" role="tabpanel">

                                                <div class="row m-5">
                                                    <img src="<?php echo e(asset('wiz-address.jpg')); ?>" alt=""
                                                        srcset="">
                                                </div>

                                                <div class="button-action mt-5">
                                                    <button class="btn btn-secondary btn-prev me-3">Prev</button>
                                                    <button class="btn btn-secondary btn-nxt">Next</button>
                                                </div>
                                            </div>
                                            <div id="defaultStep-three" class="content" role="tabpanel">
                                                <div class="row m-5">
                                                    <center>
                                                        <img src="<?php echo e(asset('wiz-mail-list.jpg')); ?>" class=" w-50"
                                                            alt="" srcset="">
                                                    </center>
                                                </div>

                                                <div class="button-action mt-3">
                                                    <button class="btn btn-secondary btn-prev me-3">Prev</button>

                                                    <a href="<?php echo e(url('app')); ?>"
                                                        class="btn btn-success me-3">Finish</a>

                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--  END CONTENT AREA  -->
    </div>

    <script src="<?php echo e(asset('src/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('layouts/modern-light-menu/app.js')); ?>"></script>
    <script src="<?php echo e(asset('src/plugins/src/stepper/bsStepper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('src/plugins/src/stepper/custom-bsStepper.min.js')); ?>"></script>

    <script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4="
        crossorigin="anonymous"></script>

    <script src="<?php echo e(asset('src/ajax.js')); ?>"></script>
    <script>
        function updateScanPermission(permission) {
            var data = {
                _token: "<?php echo e(csrf_token()); ?>",
                permission: permission,
            };

            ajax_call('post', 'setting/profile/update-scan-permission', data).then(function(response) {
            }).catch(function(error) {
                console.error('Error:', error);
            });


        }
    </script>

</body>

</html>
<?php /**PATH /home/ferdous-ahmed-khan/Project/rent-a-mailbox/resources/views/app/components/wizard.blade.php ENDPATH**/ ?>