<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">

    <meta name="description"
        content= "Get a Canadian
                                            address for personal or business
                                            use, no matter where you are in the world. Access your letters and documents
                                            online, and have them forwarded within Canada. Rentamailbox.ca provides a
                                            smarter, more convenient way to manage your postal needs, offering secure
                                            and easy handling of your important correspondence." />
    <meta name="keywords" content="mailbox, rent a mailbox, mailbox service, virtual address" />
    <meta property="og:image" content="<?php echo e(asset('hero-og.png')); ?>" />
    <meta property="og:image_secure" content="<?php echo e(asset('hero-og.png')); ?>" />
    <meta property="og:image:width" content="1200" />
    <meta property="og:image:height" content="630" />
    <meta property="og:type" content="website" />
    <meta property="og:url" content="https://rentamailbox.ca" />


    <title>Rentamailbox.ca - Canadian Virtual Address Solutions</title>



    <link rel="stylesheet" href="<?php echo e(asset('web.css')); ?>" type="text/css" />
    <link href="<?php echo e(asset('src/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('src/assets/css/light/elements/alert.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('src/assets/css/dark/elements/alert.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('layouts/modern-light-menu/css/light/plugins.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('layouts/modern-light-menu/css/dark/plugins.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('layouts/modern-light-menu/css/light/loader.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('layouts/modern-light-menu/css/dark/loader.css')); ?>" rel="stylesheet" type="text/css" />
    <script src="<?php echo e(asset('layouts/modern-light-menu/loader.js')); ?>"></script>
    <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700" rel="stylesheet">
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('favicon-logo.ico')); ?>" />
    <link href="<?php echo e(asset('src/assets/css/light/pages/knowledge_base.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('src/assets/css/dark/pages/knowledge_base.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('src/assets/css/light/pages/faq.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('src/assets/css/dark/pages/faq.css')); ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('src/assets/css/light/forms/switches.css')); ?>">
    <link href="<?php echo e(asset('src/plugins/css/light/pricing-table/css/component.css')); ?>" rel="stylesheet"
        type="text/css" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('src/assets/css/dark/forms/switches.css')); ?>">
    <link href="<?php echo e(asset('src/plugins/css/dark/pricing-table/css/component.css')); ?>" rel="stylesheet"
        type="text/css" />
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('src/plugins/src/notification/snackbar/snackbar.min.css')); ?>">
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('src/plugins/css/light/notification/snackbar/custom-snackbar.css')); ?>">
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('src/plugins/css/dark/notification/snackbar/custom-snackbar.css')); ?>">

    <link rel="stylesheet" href=<?php echo e(asset('src/plugins/src/font-icons/fontawesome/css/regular.css')); ?>>
    <link rel="stylesheet" href=<?php echo e(asset('src/plugins/src/font-icons/fontawesome/css/fontawesome.css')); ?>>
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('src/plugins/src/glightbox/glightbox.min.css')); ?>">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap"
        rel="stylesheet">
    <link
        href="https://fonts.googleapis.com/css2?family=Questrial&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap"
        rel="stylesheet">
</head>

<body class="layout-boxed">

    <!-- BEGIN LOADER -->
    <div id="load_screen">
        <div class="loader">
            <div class="loader-content">
                <div class="spinner-grow align-self-center"></div>
            </div>
        </div>
    </div>
    <!--  END LOADER -->

    <!--  BEGIN NAVBAR  -->
    <!-- Navbar Goes Here -->
    <!--  END NAVBAR  -->

    <!--  BEGIN MAIN CONTAINER  -->
    <div class="main-container " id="container">

        <div class="overlay"></div>
        <div class="search-overlay"></div>


        <!--  BEGIN CONTENT AREA  -->
        <div id="content" class="main-content ms-0 mt-0">
            <div class="hero-area pt-4">
                <div class="middle-content">
                    <div class="header">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="d-flex justify-content-between">
                                    <div class="align-self-center">
                                        <img src="<?php echo e(asset('rent-a-mailbox-logo.png')); ?>" width="230" alt="">
                                    </div>
                                    <div class="align-self-center">
                                        <?php if(Auth::check()): ?>
                                            <a href="<?php echo e(url('app')); ?>" class="btn btn-primary"
                                                style="background-color: #023276 !important">Dashboard</a>
                                        <?php else: ?>
                                            <a href="<?php echo e(url('app/login')); ?>" class="btn btn-primary"
                                                style="background-color: #023276 !important">Sign In</a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="middle-content text-left">
                        <div class="hero-content">
                            <div class="row">
                                <div class="col-md-6 col-sm-12">
                                    <div class="hero-content-left hero-left">
                                        


                                        <a href="https://www.youtube.com/watch?v=YJAJppVaOXc"
                                            class="iframeGlightbox glightbox-content">
                                            <img src="<?php echo e(asset('hero-video.png')); ?>" alt="image"
                                                class="img-fluid" />
                                        </a>
                                    </div>
                                </div>

                                <div class="col-md-6 col-sm-12">
                                    <div class="hero-content-left">
                                        <h1 style="font-size: 60px">
                                            <b>
                                                Get Virutal Address Now!
                                            </b>
                                        </h1>
                                        <p class="mt-5 hero-h5 mb-4"
                                            style="text-align: justify; font-size: 20px !important">Get a Canadian
                                            address for personal or business
                                            use, no matter where you are in the world. Access your letters and documents
                                            online, and have them forwarded within Canada. Rentamailbox.ca provides a
                                            smarter, more convenient way to manage your postal needs, offering secure
                                            and easy handling of your important correspondence.
                                        </p>

                                    </div>
                                </div>


                            </div>

                        </div>
                    </div>
                </div>

            </div>



            <div class="container feature-list-section" style="padding: 50px 50px">

                <h1 class="mb-4 heading-text" style="padding: 0">Handle your mail effortlessly—view and forward it
                    online.</h1>

                <p class="hero-h5 mb-4 text-center" style="font-size: 20px !important">Our advanced mail management
                    service offers full control over your
                    letters and documents. When new items arrive, we scan the envelope or label and send you a
                    notification. Access your account from any device to choose how to handle your mail—whether you want
                    it scanned, forwarded unopened, or discarded. The decision is entirely up to you.</p>

                <div class="faq container" style="padding-top: 50px">

                    <div class="faq-layouting layout-spacing">

                        <div class="kb-widget-section">

                            <div class="row justify-content-center">

                                <div class="col-md-4 col-sm-12 mb-3">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="card-icon mb-4">
                                                <span class="material-symbols-outlined feature-icon">
                                                    location_city
                                                </span>
                                            </div>
                                            <h5 class="card-title mb-0">Virtual Mail Address</h5>
                                            <p class="mt-2">
                                                Get a Canadian address for personal or business use, no matter where you
                                                are. Receive your important documents and correspondence securely.
                                            </p>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4 col-sm-12 mb-3">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="card-icon mb-4">
                                                <span class="material-symbols-outlined feature-icon">
                                                    mark_email_unread
                                                </span>
                                            </div>
                                            <h5 class="card-title mb-0">Mail Receive</h5>
                                            <p class="mt-2">
                                                We handle the receipt of your letters and documents at our secure
                                                Canadian location. Rest assured that your mail is received safely and
                                                confidentially.
                                            </p>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4 col-sm-12 mb-3">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="card-icon mb-4">
                                                <span class="material-symbols-outlined feature-icon">
                                                    document_scanner
                                                </span>
                                            </div>
                                            <h5 class="card-title mb-0">Mail Scan</h5>
                                            <p class="mt-2">
                                                Once your mail arrives, we scan the contents for your review. You will
                                                have access
                                                high-quality digital copies of your letters and documents from anywhere.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row justify-content-center mt-4">

                                <div class="col-md-4 col-sm-12 mb-3">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="card-icon mb-4">
                                                <span class="material-symbols-outlined feature-icon">
                                                    outgoing_mail
                                                </span>
                                            </div>
                                            <h5 class="card-title mb-0">Mail Forwarding</h5>
                                            <p class="mt-2">
                                                Choose to have your mail forwarded within Canada as needed. Whether it’s
                                                to a different address or for local delivery, we manage the forwarding
                                                process efficiently.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12 mb-3">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="card-icon mb-4">
                                                <span class="material-symbols-outlined feature-icon">
                                                    settings
                                                </span>
                                            </div>
                                            <h5 class="card-title mb-0">Online Mail Management</h5>
                                            <p class="mt-2">
                                                Access and manage your mail through our user-friendly online portal.
                                                View, sort, and handle your correspondence conveniently from any device
                                                such as Mobile, Tablet or Desktop.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-12 mb-3">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="card-icon mb-4">
                                                <span class="material-symbols-outlined feature-icon">
                                                    contact_mail
                                                </span>
                                            </div>
                                            <h5 class="card-title mb-0">Address Book</h5>
                                            <p class="mt-2">
                                                Maintain a comprehensive address book for easy management of your
                                                contacts. Quickly update and organize addresses to streamline your mail
                                                handling.

                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="container ">
                <h1 class="mb-4 heading-text" style="">How Rent A Mailbox Work?</h1>

                <div class="row justify-content-center">

                    <div class="col-md-4 col-sm-12 mb-3">
                        <div class="card">
                            <img src="<?php echo e(asset('choose-an-address.png')); ?>" class="card-img-top" alt="...">
                            <div class="card-body">
                                <h5 class="card-title mb-3">1. Get Your Virtual Address</h5>
                                <p class="card-text">Sign up on Rentamailbox.ca to receive your own unique Canadian mailing address. This mailing address will be used for receiving all your mail and documents securely.</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-12 mb-3">
                        <div class="card">
                            <img src="<?php echo e(asset('receive-mail.jpg')); ?>" class="card-img-top" alt="...">
                            <div class="card-body">
                                <h5 class="card-title mb-3">2. Mail Arrives and Gets Scanned</h5>
                                <p class="card-text">
                                    When mail is delivered to your virtual address, we scan the envelope or label and
                                    upload a digital copy to your secure account. You’ll receive a notification each
                                    time new mail arrives.
                                </p>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-12 mb-3">
                        <div class="card">
                            <img src="<?php echo e(asset('manage-it-online.webp')); ?>" class="card-img-top" alt="...">

                            <div class="card-body">
                                <h5 class="card-title mb-3">3. Manage Your Mail Online</h5>
                                <p class="card-text">
                                    Log in to your account from any device to view and manage your scanned mail. You can
                                    choose to forward the mail within Canada or handle it according to your preferences.
                                </p>
                            </div>
                        </div>
                    </div>


                </div>
            </div>




            <div class="container section price-plan">
                <h1 class="heading-text" style="padding-bottom: 0px">Price Plan</h1>

                <div class="pricing-table-2 ">

                    <!-- Billing Cycle  -->
                    <div class="billing-cycle-radios mt-5">

                        <div class="switch form-switch-custom switch-inline form-switch-primary form-switch-custom inner-label-toggle show"
                            id="type-button">
                            <div class="input-checkbox">
                                <span class="switch-chk-label label-left">Monthly</span>
                                <input class="switch-input" type="checkbox" role="switch" id="toggle-1" checked>
                                <span class="switch-chk-label label-right">Yearly</span>
                            </div>
                        </div>

                    </div>


                    <div class="pricing-plans-container mt-5 billed-yearly" id="package">
                    </div>

                </div>
            </div>







            <div class="container">
                <div class="faq">
                    <div class="faq-layouting layout-spacing">

                        <div class="fq-tab-section">
                            <div class="row">
                                <div class="col-md-12">

                                    <h1 class="mb-4 heading-text" style="">Frequently Asked Questions (FAQ)</h1>


                                    <div class="row">

                                        <div class="col-lg-12">

                                            <div class="accordion" id="simple_faq">
                                                <div class="card">
                                                    <div class="card-header" id="fqheadingOne">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseOne"
                                                            aria-expanded="false" aria-controls="fqcollapseOne">
                                                            <h5 class="">What is Rentamailbox.ca?</h5>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseOne" class="collapse"
                                                        aria-labelledby="fqheadingOne" data-bs-parent="#simple_faq">
                                                        <div class="card-body">
                                                            <p>Rentamailbox.ca provides a virtual Canadian address for
                                                                receiving, scanning, and managing your mail and
                                                                documents online, no matter where you are in the world.
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>



                                                <div class="card">
                                                    <div class="card-header" id="fqheadingThree">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseThree"
                                                            aria-expanded="false" aria-controls="fqcollapseThree">
                                                            <h5 class="">How does the virtual address service
                                                                work?</h5>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseThree" class="collapse"
                                                        aria-labelledby="fqheadingThree" data-bs-parent="#simple_faq">
                                                        <div class="card-body">
                                                            <p>You receive a unique Canadian address through
                                                                Rentamailbox.ca. When mail arrives at this address, we
                                                                scan the envelope or label and upload a digital copy to
                                                                your secure account. You can then view, forward, or
                                                                manage your mail online.</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card">
                                                    <div class="card-header" id="fqheadingFour">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseFour"
                                                            aria-expanded="false" aria-controls="fqcollapseFour">
                                                            <h5 class="">Can I use the virtual address for
                                                                business purposes?</h5>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseFour" class="collapse"
                                                        aria-labelledby="fqheadingFour" data-bs-parent="#simple_faq">
                                                        <div class="card-body">
                                                            <p>Yes, our virtual address service is suitable for both
                                                                personal and business use. You can receive business
                                                                correspondence and important documents securely.</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card">
                                                    <div class="card-header" id="fqheadingFive">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseFive"
                                                            aria-expanded="false" aria-controls="fqcollapseFive">
                                                            <h5 class="">How do I access my scanned mail?</h5>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseFive" class="collapse"
                                                        aria-labelledby="fqheadingFive" data-bs-parent="#simple_faq">
                                                        <div class="card-body">
                                                            <p>Log in to your Rentamailbox.ca account from any device to
                                                                view scanned copies of your mail. You can also choose to
                                                                forward the mail within Canada if needed.</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card">
                                                    <div class="card-header" id="fqheadingSix">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseSix"
                                                            aria-expanded="false" aria-controls="fqcollapseSix">
                                                            <h5 class="">How do I forward my mail?</h5>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseSix" class="collapse"
                                                        aria-labelledby="fqheadingSix" data-bs-parent="#simple_faq">
                                                        <div class="card-body">
                                                            <p>Once you access your mail online, you can select the
                                                                option to forward it to any Canadian address. Follow the
                                                                instructions in your account to complete the forwarding
                                                                process.</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card">
                                                    <div class="card-header" id="fqheadingSix">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseSeven"
                                                            aria-expanded="false" aria-controls="fqcollapseSeven">
                                                            <h5 class="">Is my mail secure?</h5>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseSeven" class="collapse"
                                                        aria-labelledby="fqheadingSix" data-bs-parent="#simple_faq">
                                                        <div class="card-body">
                                                            <p>Yes, we prioritize the security and confidentiality of
                                                                your mail. Your documents are scanned and managed in a
                                                                secure environment, and access to your account is
                                                                protected by robust security measures.</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card">
                                                    <div class="card-header" id="fqheadingTwo">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqcollapseTwo"
                                                            aria-expanded="false" aria-controls="fqcollapseTwo">
                                                            <h5 class="">How quickly will I receive notifications
                                                                about new mail?</h5>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqcollapseTwo" class="collapse"
                                                        aria-labelledby="fqheadingTwo" data-bs-parent="#simple_faq"
                                                        style="">
                                                        <div class="card-body">
                                                            <p>You will receive a notification as soon as new mail
                                                                arrives and is scanned. This allows you to promptly view
                                                                and manage your correspondence.
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card">
                                                    <div class="card-header" id="fqheadingEight">
                                                        <div class="mb-0 collapsed" data-bs-toggle="collapse"
                                                            role="navigation" data-bs-target="#fqheadingEight1"
                                                            aria-expanded="false" aria-controls="fqheadingEight1">
                                                            <h5 class="">How do I get started?</h5>
                                                            <div class="icons"><svg
                                                                    xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="currentColor" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="feather feather-chevron-down">
                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                </svg></div>
                                                        </div>
                                                    </div>
                                                    <div id="fqheadingEight1" class="collapse"
                                                        aria-labelledby="fqheadingEight" data-bs-parent="#simple_faq"
                                                        style="">
                                                        <div class="card-body">
                                                            <p>Sign up on Rentamailbox.ca to get your virtual Canadian
                                                                address. Follow the setup instructions provided to start
                                                                receiving and managing your mail online.
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>


                                    </div>

                                </div>
                            </div>
                        </div>

                    </div>

                </div>
            </div>



            <div class="footer-section mt-5">
                <center>
                    <p class="text-center">Copyright © NETLEXER 2024. All rights reserved.</p>
                </center>

            </div>




            <script src="<?php echo e(asset('src/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
            <script src="<?php echo e(asset('src/plugins/perfect-scrollbar/perfect-scrollbar.min.js')); ?>"></script>
            <script src="<?php echo e(asset('src/plugins/mousetrap/mousetrap.min.js')); ?>"></script>
            <script src="<?php echo e(asset('src/plugins/src/notification/snackbar/snackbar.min.js')); ?>"></script>
            <script src="<?php echo e(asset('src/assets/js/components/notification/custom-snackbar.js')); ?>"></script>
            <script src="<?php echo e(asset('src/custom.js')); ?>"></script>
            <script src="<?php echo e(asset('src/plugins/src/glightbox/glightbox.min.js')); ?>"></script>
            <script src="<?php echo e(asset('src/plugins/src/glightbox/custom-glightbox.min.js')); ?>"></script>

            <script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4="
                crossorigin="anonymous"></script>


            <script>
                $(document).ready(function() {
                    $.ajax({
                        url: "<?php echo e(route('getYearlyPackage')); ?>",
                        type: 'GET',
                        success: function(data) {
                            $('#package').html(data.html);
                        }
                    });


                    $('#toggle-1').change(function() {
                        if ($(this).is(':checked')) {
                            $.ajax({
                                url: "<?php echo e(route('getYearlyPackage')); ?>",
                                type: 'GET',
                                success: function(data) {
                                    $('#type-button').addClass('show');
                                    $('#package').html(data.html);
                                }
                            });
                        } else {
                            $.ajax({

                                url: "<?php echo e(route('getMonthlyPackage')); ?>",
                                type: 'GET',
                                success: function(data) {
                                    $('#type-button').removeClass('show');
                                    $('#package').html(data.html);
                                }
                            });
                        }
                    });

                });
            </script>

            <?php if(session('error')): ?>
                <script>
                    error_alert('<?php echo e(session('error')); ?>');
                </script>
            <?php endif; ?>

            <!--Start of Tawk.to Script-->
            <script type="text/javascript">
                var Tawk_API = Tawk_API || {},
                    Tawk_LoadStart = new Date();
                (function() {
                    var s1 = document.createElement("script"),
                        s0 = document.getElementsByTagName("script")[0];
                    s1.async = true;
                    s1.src = 'https://embed.tawk.to/66c9fa7cea492f34bc09b2a2/1i62fktpo';
                    s1.charset = 'UTF-8';
                    s1.setAttribute('crossorigin', '*');
                    s0.parentNode.insertBefore(s1, s0);
                })();
            </script>
            <!--End of Tawk.to Script-->

</body>

</html>
<?php /**PATH /home/ferdous-ahmed-khan/Project/rent-a-mailbox/resources/views/web/index2.blade.php ENDPATH**/ ?>