<?php $__env->startSection('title', 'Users'); ?>
<?php $__env->startSection('header'); ?>
    <?php echo $__env->make('app.components.datatable-css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="layout-px-spacing">

        <div class="middle-content container-xxl p-0">

            <div class="page-meta mt-5">
                <nav class="breadcrumb-style-one" aria-label="breadcrumb">
                    <div class="row">
                        <div class="col">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item active" aria-current="page">Users</li>
                            </ol>
                        </div>
                        <div class="col text-right d-flex justify-content-end">
                            <button class="btn btn-primary" id="add_item">Add New</button>
                        </div>
                    </div>
                </nav>
            </div>



            <div class="row layout-top-spacing">

                <div class="col-xl-12 col-lg-12 col-sm-12  layout-spacing">
                    <div class="widget-content widget-content-area br-8">

                        <table id="zero-config" class="table dt-table-hover" style="width:100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Role</th>
                                    <th class="no-content">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr id="item_<?php echo e($item->id); ?>">
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($item->full_name); ?></td>
                                        <td><?php echo e($item->email); ?></td>
                                        <td>

                                            <span class="badge badge-info">
                                                <?php echo e($item->role->name); ?>

                                            </span>

                                        </td>
                                        <td>
                                            <button class="btn-crud" onclick="editItem(<?php echo e($item->id); ?>)">
                                                <span class="material-symbols-outlined">
                                                    edit
                                                </span>
                                            </button>

                                            <button class="btn-crud" onclick="deleteItem(<?php echo e($item->id); ?>)">
                                                <span class="material-symbols-outlined">
                                                    delete
                                                </span>
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="crud_modal"></div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
    <?php echo $__env->make('app.components.datatable-js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        $('#add_item').click(function() {
            $.ajax({
                type: "GET",
                url: "users/create",
                dataType: "JSON",
                success: function(data) {
                    console.log(data)
                    $("#crud_modal").html(data.html);
                    $("#exampleModal").modal("show");
                },
                error(res) {
                    console.log(res)
                }
            });
        });



        $(document).on('click', '#create', function() {

            $.ajax({
                type: "POST",
                url: "users",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    full_name: $('#full_name').val(),
                    email: $('#email').val(),
                    password: $('#password').val(),
                    role_name: $('#role_name').val(),
                },
                dataType: "JSON",
                success: function(data) {
                    console.log(data)
                    $("#exampleModal").modal("hide");
                    success_alert(data.message);
                    setTimeout(function() {
                        window.location.reload();
                    }, 3000);

                },
                error(res) {
                    console.log(res)
                    error_alert(res.responseJSON.message);
                    $('#error_message').html('');
                    for (const key in res.responseJSON.errors) {
                        if (Object.hasOwnProperty.call(res.responseJSON.errors, key)) {
                            const element = res.responseJSON.errors[key];
                            $('#error_message').append('<div class="alert alert-danger">' + element +
                                '</div>');
                        }
                    }
                }
            });
        });

        function deleteItem(id) {

            if (confirm("Are you sure you want to delete this item?")) {
                $.ajax({
                    type: "DELETE",
                    url: "users/" + id,
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                    },
                    dataType: "JSON",
                    success: function(data) {
                        console.log(data);
                        success_alert(data.message);
                        $('#item_' + id).remove();

                    },
                    error: function(res) {
                        console.log(res);
                        error_alert(res.responseJSON.message);
                    }
                });
            }
        }

        function editItem(id) {
            $.ajax({
                type: "GET",
                url: "users/" + id + "/edit",
                dataType: "JSON",
                success: function(data) {
                    console.log(data)
                    $("#crud_modal").html(data.html);
                    $("#exampleModal").modal("show");
                },
                error(res) {
                    console.log(res)
                }
            });
        }

        $(document).on('click', '#update', function() {
            var id = $('#user_id').val();
            $.ajax({
                type: "PUT",
                url: "users/" + id,
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    full_name: $('#full_name').val(),
                    email: $('#email').val(),
                    password: $('#password').val(),
                    role_name: $('#role_name').val(),
                },
                dataType: "JSON",
                success: function(data) {
                    console.log(data)
                    $("#exampleModal").modal("hide");
                    success_alert(data.message);
                    setTimeout(function() {
                        window.location.reload();
                    }, 3000);

                },
                error(res) {
                    console.log(res)
                    error_alert(res.responseJSON.message);
                    $('#error_message').html('');
                    for (const key in res.responseJSON.errors) {
                        if (Object.hasOwnProperty.call(res.responseJSON.errors, key)) {
                            const element = res.responseJSON.errors[key];
                            $('#error_message').append('<div class="alert alert-danger">' + element +
                                '</div>');
                        }
                    }
                }
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('app.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ferdous-ahmed-khan/Project/rent-a-mailbox/resources/views/app/users/index.blade.php ENDPATH**/ ?>